/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import java.io.IOException;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.remote.fs.RemoteDirectory;
import org.netbeans.modules.cnd.remote.fs.RemoteFileObjectBase;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSupport;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

@SuppressWarnings(value={"Se"})
public class RemoteFileSystem
extends FileSystem {
    private static final SystemAction[] NO_SYSTEM_ACTIONS = new SystemAction[0];
    private final ExecutionEnvironment execEnv;
    private final String filePrefix;
    private final RemoteFileObjectBase root;
    private final RemoteFileSupport remoteFileSupport;
    private final File cache;

    public RemoteFileSystem(ExecutionEnvironment execEnv) throws IOException {
        CndUtils.assertTrue((boolean)execEnv.isRemote());
        this.execEnv = execEnv;
        this.remoteFileSupport = new RemoteFileSupport(execEnv);
        this.filePrefix = CndUtils.getIncludeFilePrefix((String)EnvUtils.toHostID((ExecutionEnvironment)execEnv));
        this.cache = new File(this.filePrefix);
        if (!this.cache.exists() && !this.cache.mkdirs()) {
            throw new IOException(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_CreateDir", (Object)this.cache.getAbsolutePath()));
        }
        this.root = new RootFileObject(this, execEnv, this.cache);
    }

    File getCache() {
        return this.cache;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RFS_DISPLAY_NAME", (Object)this.execEnv.getDisplayName());
    }

    public boolean isReadOnly() {
        return true;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public FileObject findResource(String name) {
        if (name.isEmpty() || name.equals("/")) {
            return this.getRoot();
        }
        return this.getRoot().getFileObject(name);
    }

    public SystemAction[] getActions() {
        return NO_SYSTEM_ACTIONS;
    }

    public RemoteFileSupport getRemoteFileSupport() {
        return this.remoteFileSupport;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static class RootFileObject
    extends RemoteDirectory {
        public RootFileObject(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, File cache) {
            super(fileSystem, execEnv, null, "", cache);
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
}

