/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.ui.LogoutPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class LogoutAction
extends AbstractAction {
    private static LogoutAction instance;
    private static final String LOGOUT;

    private LogoutAction() {
        super(LOGOUT);
    }

    public static synchronized LogoutAction getDefault() {
        if (instance == null) {
            instance = new LogoutAction();
        }
        return instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final Collection kenais = KenaiManager.getDefault().getKenais();
        if (kenais.size() == 1) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ((Kenai)kenais.iterator().next()).logout();
                }
            });
            return;
        }
        final LogoutPanel panel = new LogoutPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(LogoutAction.class, (String)"LOGOUT_TITLE"), true, new Object[]{LOGOUT, DialogDescriptor.CANCEL_OPTION}, (Object)LOGOUT, 0, null, null);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == LOGOUT) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    for (Kenai k : panel.getSelectedKenais()) {
                        if (k.getStatus() == Kenai.Status.OFFLINE) continue;
                        k.logout();
                    }
                }
            });
        }
    }

    @Override
    public boolean isEnabled() {
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            if (k.getStatus() == Kenai.Status.OFFLINE) continue;
            return true;
        }
        return false;
    }

    static {
        LOGOUT = NbBundle.getMessage(LogoutAction.class, (String)"CTL_LogoutAction");
    }
}

