/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.server.manager.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class EditDialogDescriptor
extends DialogDescriptor
implements ChangeListener {
    public static final String STATUS_PREFIX = "Status:";

    public EditDialogDescriptor(JPanel panel, String title, boolean add, JComponent[] components, HelpCtx helpCtx) {
        this(new InnerPanel(panel), title, add, components, helpCtx);
    }

    private EditDialogDescriptor(InnerPanel innerPanel, String title, boolean add, JComponent[] components, HelpCtx helpCtx) {
        super((Object)innerPanel, EditDialogDescriptor.getTitle(add, title), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
        if (components != null) {
            DocListener listener = new DocListener(this);
            for (JComponent component : components) {
                if (!(component instanceof JTextField)) continue;
                ((JTextField)component).getDocument().addDocumentListener(listener);
            }
        }
        this.checkValues();
    }

    private static String getTitle(boolean add, String title) {
        return add ? NbBundle.getMessage(EditDialogDescriptor.class, (String)"TTL_Add", (Object)title) : NbBundle.getMessage(EditDialogDescriptor.class, (String)"TTL_Edit", (Object)title);
    }

    public final void checkValues() {
        String errorMessage = this.validate();
        if (errorMessage == null) {
            this.setValid(true);
        } else {
            this.setValid(false);
        }
        JLabel errorLabel = ((InnerPanel)this.getMessage()).getErrorLabel();
        if (errorMessage != null) {
            if (errorMessage.startsWith(STATUS_PREFIX)) {
                errorMessage = errorMessage.substring(STATUS_PREFIX.length());
                errorLabel.setForeground(Color.BLACK);
            } else {
                errorLabel.setForeground(Color.RED);
            }
        }
        errorLabel.setText(errorMessage == null ? " " : errorMessage);
    }

    protected abstract String validate();

    @Override
    public void stateChanged(ChangeEvent e) {
        this.checkValues();
    }

    public JLabel getErrorLabel() {
        return ((InnerPanel)this.getMessage()).getErrorLabel();
    }

    public static interface Panel {
        public JComponent[] getEditableComponents();
    }

    public static class DocListener
    implements DocumentListener {
        EditDialogDescriptor dialog;

        public DocListener(EditDialogDescriptor dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            this.dialog.checkValues();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.dialog.checkValues();
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.dialog.checkValues();
        }
    }

    private static class InnerPanel
    extends JPanel {
        JLabel errorLabel;

        InnerPanel(JPanel panel) {
            JSeparator separator = new JSeparator();
            this.errorLabel = new JLabel(" ");
            this.errorLabel.setForeground(Color.RED);
            GroupLayout layout = new GroupLayout((Container)this);
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)separator, -1, 380, Short.MAX_VALUE).addContainerGap()).add((Component)panel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.errorLabel, -1, 380, Short.MAX_VALUE).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)panel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)separator, -2, 10, -2).addPreferredGap(0).add((Component)this.errorLabel, -2, 14, -2).addContainerGap()));
        }

        void setErrorMessage(String message) {
            this.errorLabel.setText(message);
        }

        JLabel getErrorLabel() {
            return this.errorLabel;
        }
    }
}

