/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.resource;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceCategoryDescriptor;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.netbeans.modules.vmd.screen.ScreenAccessController;
import org.netbeans.modules.vmd.screen.resource.ResourceCategoryPanel;
import org.netbeans.modules.vmd.screen.resource.ResourcePanelSupport;

public class ResourcePanel
extends JPanel {
    private ScreenAccessController controller;
    private JPanel fillPanel;

    public ResourcePanel(ScreenAccessController controller) {
        this.controller = controller;
        this.setBackground(MainPanel.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        this.fillPanel = new JPanel();
        this.fillPanel.setBackground(MainPanel.BACKGROUND_COLOR);
        this.fillPanel.setPreferredSize(new Dimension(250, 0));
    }

    public void reload() {
        DesignComponent editedScreen = this.controller.getEditedScreen();
        Map<ScreenResourceCategoryDescriptor, ArrayList<ScreenResourceItemPresenter>> categories = ResourcePanelSupport.getCategoryDescriptors(editedScreen);
        ResourcePanelSupport.resolveResources(this.controller.getDocument(), editedScreen, categories);
        List<ScreenResourceCategoryDescriptor> sortedCategories = ResourcePanelSupport.getSortedCategories(categories.keySet());
        this.removeAll();
        int y = 0;
        for (ScreenResourceCategoryDescriptor category : sortedCategories) {
            ResourceCategoryPanel categoryPanel = new ResourceCategoryPanel(category);
            categoryPanel.reload(categories.get(category));
            this.add((Component)categoryPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 20, 0), 0, 0));
        }
        this.add((Component)this.fillPanel, new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

