/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class DiffStreamSource
extends StreamSource
implements Cancellable {
    private final File baseFile;
    private final String revision;
    private final String pegRevision;
    private final String title;
    private String mimeType;
    private SVNUrl url;
    private SVNUrl repoUrl;
    private SvnClient client;
    private File remoteFile;

    public DiffStreamSource(File baseFile, SVNUrl repoUrl, SVNUrl fileUrl, String revision, String title) {
        this.baseFile = baseFile;
        this.revision = this.pegRevision = revision;
        this.title = title;
        this.url = fileUrl;
        this.repoUrl = repoUrl;
    }

    public DiffStreamSource(File baseFile, SVNUrl repoUrl, SVNUrl fileUrl, String revision, String pegRevision, String title) {
        this.baseFile = baseFile;
        this.revision = revision;
        this.pegRevision = pegRevision;
        this.title = title;
        this.url = fileUrl;
        this.repoUrl = repoUrl;
    }

    public String getName() {
        if (this.baseFile != null) {
            return this.baseFile.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        try {
            this.init();
        }
        catch (IOException e) {
            Subversion.LOG.log(Level.INFO, "DiffStreamSource.getMIMEType() returns null", e);
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init();
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((File)this.remoteFile);
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return false;
    }

    private boolean isPrimary() {
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                return fo.equals(dao.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException e) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject remoteFo = FileUtil.toFileObject((File)this.remoteFile);
        if (remoteFo == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{remoteFo});
    }

    synchronized void init() throws IOException {
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        if (this.baseFile.isDirectory()) {
            this.mimeType = "content/unknown";
            return;
        }
        this.mimeType = SvnUtils.getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision);
            } else {
                File rf = VersionsCache.getInstance().getFileRevision(this.repoUrl, this.url, this.revision, this.pegRevision, this.baseFile.getName());
                if (rf == null) {
                    this.remoteFile = null;
                    return;
                }
                this.remoteFile = rf;
                Utils.associateEncoding((File)this.baseFile, (File)rf);
            }
        }
        catch (IOException e) {
            if (e.getCause() != null && SvnClientExceptionHandler.isTargetDirectory(e.getCause().getMessage()) || SvnClientExceptionHandler.isTargetDirectory(e.getMessage())) {
                Subversion.LOG.log(Level.FINE, "", e);
                this.mimeType = "content/unknown";
                return;
            }
            throw e;
        }
        if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
            this.mimeType = SvnUtils.getMimeType(this.remoteFile);
        }
    }

    public boolean cancel() {
        if (this.client != null) {
            this.client.cancel();
        }
        return true;
    }
}

