/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.io.IOException;
import javax.imageio.ImageIO;
import org.netbeans.modules.image.ImageDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class ImageDataLoader
extends UniFileLoader {
    static final long serialVersionUID = -8188309025795898449L;
    private static final String BMP_MIME_TYPE = "image/bmp";
    private static boolean bmpSupportStatusKnown = false;

    public ImageDataLoader() {
        super("org.netbeans.modules.image.ImageDataObject");
        ExtensionList ext = new ExtensionList();
        ext.addMimeType("image/gif");
        ext.addMimeType("image/jpeg");
        ext.addMimeType("image/png");
        this.setExtensions(ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject findPrimaryFile(FileObject fo) {
        FileObject primFile = super.findPrimaryFile(fo);
        if (primFile == null && !bmpSupportStatusKnown && !fo.isFolder() && fo.getMIMEType().equals(BMP_MIME_TYPE)) {
            try {
                if (ImageIO.getImageReadersByMIMEType(BMP_MIME_TYPE).hasNext()) {
                    this.getExtensions().addMimeType(BMP_MIME_TYPE);
                    primFile = fo;
                }
            }
            finally {
                bmpSupportStatusKnown = true;
            }
        }
        return primFile;
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle((Class)ImageDataLoader.class).getString("PROP_ImageLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/image/png-gif-jpeg-bmp/Actions/";
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new ImageDataObject(primaryFile, (MultiFileLoader)this);
    }
}

