/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.debugger");
    private List connectors;
    private JComboBox cbConnectors;
    private JTextField[] tfParams;
    private ConnectController controller;
    private final DocumentListener validityDocumentListener = new ValidityDocumentListener();

    public ConnectPanel() {
        int n;
        String string;
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        this.connectors = new ArrayList();
        this.connectors.addAll(virtualMachineManager.attachingConnectors());
        this.connectors.addAll(virtualMachineManager.listeningConnectors());
        Iterator iterator = this.connectors.iterator();
        while (iterator.hasNext()) {
            string = ((Connector)iterator.next()).name();
            n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            if (!string.equalsIgnoreCase("SACoreAttachingConnector") && !string.equalsIgnoreCase("SAPIDAttachingConnector") && !string.equalsIgnoreCase("SADebugServerAttachingConnector")) continue;
            iterator.remove();
        }
        if (this.connectors.size() == 0) {
            this.add(new JLabel(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_No_Connector")));
            return;
        }
        int n2 = 0;
        if (this.connectors.size() > 1) {
            this.cbConnectors = new JComboBox();
            this.cbConnectors.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Connector"));
            string = Properties.getDefault().getProperties("debugger").getString("last_attaching_connector", "");
            int n3 = this.connectors.size();
            for (n = 0; n < n3; ++n) {
                int n4;
                Connector connector = (Connector)this.connectors.get(n);
                if (string != null && connector.name().equals(string)) {
                    n2 = n;
                }
                String string2 = (n4 = connector.name().lastIndexOf(46)) < 0 ? connector.name() : connector.name().substring(n4 + 1);
                this.cbConnectors.addItem(string2 + " (" + connector.description() + ")");
            }
            this.cbConnectors.setActionCommand("SwitchMe!");
            this.cbConnectors.addActionListener(this);
        }
        this.controller = new ConnectController();
        this.cbConnectors.setSelectedIndex(n2);
    }

    public Controller getController() {
        return this.controller;
    }

    private void refresh(int n, Properties properties) {
        Object object;
        JLabel jLabel;
        GridBagConstraints gridBagConstraints;
        this.removeAll();
        Connector connector = (Connector)this.connectors.get(n);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        if (this.cbConnectors != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 3, 3);
            gridBagConstraints.anchor = 17;
            jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Connector"));
            jLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Connector"));
            jLabel.setLabelFor(this.cbConnectors);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.insets = new Insets(0, 3, 3, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.cbConnectors, gridBagConstraints);
            this.add(this.cbConnectors);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 0, 6);
        gridBagConstraints.anchor = 17;
        jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Transport"));
        jLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Transport"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        final JTextField jTextField = new JTextField();
        jTextField.setEditable(false);
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        Transport transport = connector.transport();
        jTextField.setText(transport != null ? transport.name() : "");
        jTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Transport"));
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTextField.selectAll();
            }
        });
        this.add(jTextField);
        Map map = ConnectPanel.getSavedArgs(connector, properties);
        this.tfParams = new JTextField[map.size()];
        Iterator iterator = new TreeSet(map.keySet()).iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Connector.Argument argument = (Connector.Argument)map.get(object);
            String string = ConnectPanel.translate(argument.name());
            if (string == null) {
                string = "&" + argument.label();
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(6, 0, 0, 3);
            gridBagConstraints.anchor = 17;
            JLabel jLabel2 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel2, (String)string);
            jLabel2.setToolTipText(argument.description());
            this.add((Component)jLabel2, gridBagConstraints);
            JTextField jTextField2 = new JTextField(argument.value());
            jLabel2.setLabelFor(jTextField2);
            jTextField2.setName((String)object);
            jTextField2.getAccessibleContext().setAccessibleDescription(new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"ACSD_CTL_Argument")).format(new Object[]{string}));
            jTextField2.setToolTipText(argument.description());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(6, 3, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jTextField2, gridBagConstraints);
            jTextField2.getDocument().addDocumentListener(this.validityDocumentListener);
            this.tfParams[n2++] = jTextField2;
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        object = new JPanel();
        ((JComponent)object).setPreferredSize(new Dimension(1, 1));
        this.add((Component)object, gridBagConstraints);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectPanel.this.checkValid();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Container container;
        this.refresh(((JComboBox)actionEvent.getSource()).getSelectedIndex(), Properties.getDefault().getProperties("debugger"));
        for (container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (container != null) {
            ((Window)container).pack();
        }
    }

    private static void log(Connector connector, Map<Object, Object> map) {
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_DEBUG_ATTACH_JPDA");
        logRecord.setResourceBundle(NbBundle.getBundle(ConnectPanel.class));
        logRecord.setResourceBundleName(ConnectPanel.class.getPackage().getName() + ".Bundle");
        logRecord.setLoggerName(USG_LOGGER.getName());
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        arrayList.add(connector.name());
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append(", ");
        }
        if (stringBuilder.length() > 2) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        arrayList.add(stringBuilder);
        logRecord.setParameters(arrayList.toArray(new Object[arrayList.size()]));
        USG_LOGGER.log(logRecord);
    }

    private static boolean isUnknownHost(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (n < 6) {
            return false;
        }
        char c = string.charAt(0);
        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '-') {
            return false;
        }
        char c2 = string.charAt(5);
        if (c2 == c) {
            return string.substring(1, 5).equalsIgnoreCase("none");
        }
        if (n < 9) {
            return false;
        }
        c2 = string.charAt(8);
        if (c2 == c) {
            return string.substring(1, 8).equalsIgnoreCase("unknown");
        }
        return false;
    }

    private static Map getSavedArgs(Connector connector, Properties properties) {
        Map<String, Connector.Argument> map = connector.defaultArguments();
        Map map2 = properties.getMap("connection_settings", new HashMap());
        if ((map2 = (Map)map2.get(connector.name())) == null) {
            return map;
        }
        for (String string : map.keySet()) {
            String string2 = (String)map2.get(string);
            if (string2 == null) continue;
            map.get(string).setValue(string2);
        }
        return map;
    }

    private static Map getEditedArgs(JTextField[] jTextFieldArray, Connector connector) {
        Map<String, Connector.Argument> map = connector.defaultArguments();
        for (JTextField jTextField : jTextFieldArray) {
            String string = jTextField.getName();
            String string2 = jTextField.getText();
            Connector.Argument argument = map.get(string);
            while (!argument.isValid(string2) && !"".equals(string2) || "".equals(string2) && argument.mustSpecify()) {
                NotifyDescriptor.InputLine inputLine = null;
                String string3 = ConnectPanel.getLabel(argument);
                inputLine = "".equals(string2) && argument.mustSpecify() ? new NotifyDescriptor.InputLine(string3, NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Required_value_title")) : new NotifyDescriptor.InputLine(string3, NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Invalid_value_title"));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.CANCEL_OPTION) {
                    return null;
                }
                string2 = inputLine.getInputText();
            }
            argument.setValue(string2);
        }
        return map;
    }

    private static void saveArgs(Map map, Connector connector) {
        Object object;
        Object object22;
        Map<String, Connector.Argument> map2 = connector.defaultArguments();
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object object22 : map.keySet()) {
            object = (Connector.Argument)map.get(object22);
            Connector.Argument argument = map2.get(object22);
            if (object == null || object == argument || object.equals(argument)) continue;
            hashMap.put(object22, object.value());
        }
        object22 = Properties.getDefault().getProperties("debugger").getMap("connection_settings", new HashMap());
        object = connector.name();
        object22.put(object, hashMap);
        Properties.getDefault().getProperties("debugger").setString("last_attaching_connector", (String)object);
        Properties.getDefault().getProperties("debugger").setMap("connection_settings", (Map)object22);
    }

    private static String getLabel(Connector.Argument argument) {
        String string = ConnectPanel.translate(argument.name());
        if (string == null) {
            string = argument.label();
        } else {
            int n = Mnemonics.findMnemonicAmpersand((String)string);
            if (n >= 0) {
                string = string.substring(0, n) + string.substring(n + 1);
            }
        }
        return string;
    }

    private static String translate(String string) {
        try {
            return NbBundle.getMessage(ConnectPanel.class, (String)("CTL_CA_" + string));
        }
        catch (MissingResourceException missingResourceException) {
            ErrorManager.getDefault().log(16, "Missing resource CTL_CA_" + string + " from " + ConnectPanel.class.getName());
            return null;
        }
    }

    private void checkValid() {
        int n;
        int n2 = this.cbConnectors.getSelectedIndex();
        Connector connector = (Connector)this.connectors.get(n2);
        int n3 = this.tfParams.length;
        Map<String, Connector.Argument> map = connector.defaultArguments();
        for (n = 0; n < n3; ++n) {
            JTextField jTextField = this.tfParams[n];
            String string = jTextField.getName();
            String string2 = jTextField.getText();
            Connector.Argument argument = map.get(string);
            if (argument.mustSpecify() && "".equals(string2)) {
                String string3 = NbBundle.getMessage(ConnectPanel.class, (String)"MSG_Required_value", (Object)ConnectPanel.getLabel(argument));
                this.controller.setInformationMessage(string3);
                this.controller.setValid(false);
                break;
            }
            if ("".equals(string2) || argument.isValid(string2)) continue;
            String string4 = NbBundle.getMessage(ConnectPanel.class, (String)"MSG_Invalid_value", (Object)ConnectPanel.getLabel(argument));
            this.controller.setErrorMessage(string4);
            this.controller.setValid(false);
            break;
        }
        if (n >= n3) {
            this.controller.setErrorMessage(null);
            this.controller.setValid(true);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("debug.jpda.attach");
    }

    public class ConnectController
    implements Controller {
        PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private boolean valid = true;

        public boolean cancel() {
            return true;
        }

        public boolean ok() {
            RequestProcessor.Task[] taskArray;
            int n = ConnectPanel.this.cbConnectors.getSelectedIndex();
            final Connector connector = (Connector)ConnectPanel.this.connectors.get(n);
            final Map map = ConnectPanel.getEditedArgs(ConnectPanel.this.tfParams, connector);
            if (map == null) {
                return true;
            }
            ConnectPanel.saveArgs(map, connector);
            ConnectPanel.log(connector, map);
            taskArray = new RequestProcessor.Task[]{new RequestProcessor("JPDA Debugger Starting").create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    final Thread thread = Thread.currentThread();
                    ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ConnectPanel.class, (String)"CTL_connectProgress"), (Cancellable)new Cancellable(){

                        public boolean cancel() {
                            thread.interrupt();
                            return taskArray[0].isFinished();
                        }
                    });
                    try {
                        progressHandle.start();
                        DebuggerEngine[] debuggerEngineArray = null;
                        if (connector instanceof AttachingConnector) {
                            debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-AttachingDICookie", (Object[])new Object[]{AttachingDICookie.create((AttachingConnector)((AttachingConnector)connector), (Map)map)}));
                        } else if (connector instanceof ListeningConnector) {
                            debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-jpda-ListeningDICookie", (Object[])new Object[]{ListeningDICookie.create((ListeningConnector)((ListeningConnector)connector), (Map)map)}));
                        }
                        if (debuggerEngineArray != null) {
                            for (int i = 0; i < debuggerEngineArray.length; ++i) {
                                JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngineArray[i].lookupFirst(null, JPDADebugger.class);
                                if (jPDADebugger == null) continue;
                                try {
                                    if (jPDADebugger.getState() == 2) continue;
                                    jPDADebugger.waitRunning();
                                    continue;
                                }
                                catch (DebuggerStartException debuggerStartException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
            })};
            taskArray[0].schedule(0);
            return true;
        }

        public boolean load(Properties properties) {
            int n;
            String string = properties.getString("attaching_connector", "");
            int n2 = ConnectPanel.this.connectors.size();
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                Connector connector = (Connector)ConnectPanel.this.connectors.get(n);
                if (!connector.name().equals(string)) continue;
                ConnectPanel.this.cbConnectors.setSelectedIndex(n);
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            ConnectPanel.this.refresh(n, properties);
            return true;
        }

        public void save(Properties properties) {
            Object object;
            Object object22;
            int n = ConnectPanel.this.cbConnectors.getSelectedIndex();
            Connector connector = (Connector)ConnectPanel.this.connectors.get(n);
            Map map = ConnectPanel.getEditedArgs(ConnectPanel.this.tfParams, connector);
            if (map == null) {
                return;
            }
            Map<String, Connector.Argument> map2 = connector.defaultArguments();
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            for (Object object22 : map.keySet()) {
                object = (Connector.Argument)map.get(object22);
                Connector.Argument argument = map2.get(object22);
                if (object == null || object == argument || object.equals(argument)) continue;
                hashMap.put(object22, object.value());
            }
            object22 = new HashMap();
            object = connector.name();
            object22.put(object, hashMap);
            properties.setMap("connection_settings", (Map)object22);
            properties.setString("attaching_connector", connector.name());
        }

        public String getDisplayName() {
            AttachingDICookie attachingDICookie;
            int n = ConnectPanel.this.cbConnectors.getSelectedIndex();
            Connector connector = (Connector)ConnectPanel.this.connectors.get(n);
            Map map = ConnectPanel.getEditedArgs(ConnectPanel.this.tfParams, connector);
            if (map == null) {
                return "";
            }
            if (connector instanceof AttachingConnector) {
                attachingDICookie = AttachingDICookie.create((AttachingConnector)((AttachingConnector)connector), (Map)map);
                if (attachingDICookie.getHostName() != null) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Attach_to_socket")).format(new Object[]{attachingDICookie.getHostName(), String.valueOf(attachingDICookie.getPortNumber())});
                }
                if (attachingDICookie.getSharedMemoryName() != null) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Attach_to_shmem")).format(new Object[]{attachingDICookie.getSharedMemoryName()});
                }
                if (attachingDICookie.getArgs().get("pid") != null) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Attach_to_pid")).format(new Object[]{((Connector.Argument)attachingDICookie.getArgs().get("pid")).toString()});
                }
            }
            if (connector instanceof ListeningConnector) {
                attachingDICookie = ListeningDICookie.create((ListeningConnector)((ListeningConnector)connector), (Map)map);
                if (attachingDICookie.getSharedMemoryName() != null) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Listen_on_shmem")).format(new Object[]{attachingDICookie.getSharedMemoryName()});
                }
                if (attachingDICookie.getPortNumber() > 0) {
                    return new MessageFormat(NbBundle.getMessage(ConnectPanel.class, (String)"CTL_Listen_on_socket")).format(new Object[]{String.valueOf(attachingDICookie.getPortNumber())});
                }
            }
            return "";
        }

        public boolean isValid() {
            return this.valid;
        }

        void setValid(boolean bl) {
            this.valid = bl;
            this.firePropertyChange("valid", !bl, bl);
        }

        void setErrorMessage(String string) {
            this.firePropertyChange("errorNotification", null, string);
        }

        void setInformationMessage(String string) {
            this.firePropertyChange("infoNotification", null, string);
        }

        private void firePropertyChange(String string, Object object, Object object2) {
            this.pcs.firePropertyChange(string, object, object2);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ConnectPanel.this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ConnectPanel.this.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            ConnectPanel.this.checkValid();
        }
    }
}

