/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;

public final class DTraceScriptUtils {
    public static final String EOF_MARKER = "__EOF_MARKER__";

    private DTraceScriptUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertEOFMarker(File script) throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(script, true));
        try {
            w.write("END { printf(\"__EOF_MARKER__\") }");
        }
        finally {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File mergeScripts(Map<String, URL> scripts, boolean fixStarttime) throws IOException {
        File result = File.createTempFile("dlight", ".d");
        result.deleteOnExit();
        boolean beginContext = false;
        BufferedWriter w = new BufferedWriter(new FileWriter(result));
        try {
            w.write("#!/usr/sbin/dtrace -wZCqs\n");
            w.write("BEGIN{system(\"prun %d\", $1);}\n");
            for (Map.Entry<String, URL> entry : scripts.entrySet()) {
                String prefix = entry.getKey();
                URL url = entry.getValue();
                BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
                try {
                    String replacement = "$1" + prefix;
                    String line = r.readLine();
                    while (line != null) {
                        if (!line.startsWith("#!")) {
                            line = line.replaceAll("(print[af]\\(\")", replacement);
                            if (fixStarttime) {
                                if (!beginContext && line.trim().startsWith("BEGIN")) {
                                    beginContext = true;
                                }
                                if (beginContext && (line = line.replaceAll("=.*timestamp", "= \\$2")).trim().endsWith("}")) {
                                    beginContext = false;
                                }
                            }
                            w.write(line);
                            w.write(10);
                        }
                        line = r.readLine();
                    }
                    w.write(10);
                    w.write("proc:::exit/pid==$1/{exit(0);}\n");
                }
                finally {
                    r.close();
                }
            }
        }
        finally {
            w.close();
        }
        return result;
    }

    public static String uploadScript(ExecutionEnvironment execEnv, File scriptFile) {
        String scriptPath = null;
        if (execEnv.isLocal()) {
            scriptPath = scriptFile.getAbsolutePath();
            Util.setExecutionPermissions(Arrays.asList(scriptPath));
        } else {
            String briefName = scriptFile.getName();
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
                scriptPath = hostInfo.getTempDir() + "/" + briefName;
                Future copyResult = CommonTasksSupport.uploadFile((String)scriptFile.getAbsolutePath(), (ExecutionEnvironment)execEnv, (String)scriptPath, (int)511, null);
                copyResult.get();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return scriptPath;
    }
}

