-- File: Inc.vhd
-- Generated by MyHDL 0.7
-- Date: Sun Dec 19 16:52:33 2010


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_07.all;

entity Inc is
    port (
        count: inout unsigned(7 downto 0);
        enable: in std_logic;
        clock: in std_logic;
        reset: in std_logic
    );
end entity Inc;
-- Incrementer with enable.
-- 
-- count -- output
-- enable -- control input, increment when 1
-- clock -- clock input
-- reset -- asynchronous reset input
-- n -- counter max value

architecture MyHDL of Inc is


begin




INC_INCLOGIC: process (clock, reset) is
begin
    if (reset = '0') then
        count <= "00000000";
    elsif rising_edge(clock) then
        if to_boolean(enable) then
            count <= ((count + 1) mod 256);
        end if;
    end if;
end process INC_INCLOGIC;

end architecture MyHDL;
