# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.pigment_controller import PigmentController

class BasePlayerController(PigmentController):
    PlayerOsdClass = None
    needs = []

    def __init__(self):
        super(BasePlayerController, self).__init__()

        # On Screen Display
        if self.PlayerOsdClass:
            self.player_osd = self.PlayerOsdClass()
            self.widget.add(self.player_osd)

            self.player_osd.position = (0.0, 0.0, 0.5)
            self.player_osd.size = (1.0, 1.0)
            self.player_osd.opacity = 0
            self.player_osd.visible = True
            self.player_osd.bg_a = 0  # FIXME: is this still needed?

            # react on visibility of the OSD to make sure that the counter will
            # disappear when the OSD appears and vice-versa
            self.player_osd.connect('hidden', self._player_osd_hidden_cb)
            self.player_osd.connect('shown', self._player_osd_shown_cb)

            # connect to the seeking and volume bars
            self.player_osd.status.connect('volume-changed', self._volume_bar_cb)
            # connect to the back button
            self.player_osd.mouse_osd.back_button.connect('activated',
                                                        self._on_back_activated)
        else:
            self.player_osd = None

    def clean(self):
        self.player_osd.mouse_osd.back_button.disconnect_by_func(self._on_back_activated)
        dfr = super(BasePlayerController, self).clean()
        return dfr

    def is_compatible(self, other_player):
        """ Check if the player can be used at same time than
        L{other_player}. Check is based on what each player needs. So
        if one player needs only AUDIO and another player only needs
        IMAGE, they are compatible.

        @param other_player: player to check against ours
        @type other_player: L{BasePlayerController}
        @rtype: bool
        """
        intersection = set(self.needs).intersection(set(other_player.needs))
        return len(intersection) == 0

    def _on_back_activated(self, back_button):
        if self.has_focus():
            self.exit()
        return True

    def _player_osd_hidden_cb(self, player_osd):
        pass

    def _player_osd_shown_cb(self, player_osd):
        pass

    def _volume_bar_cb(self, widget, position):
        pass

