/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Locale;
import org.openstreetmap.josm.tools.I18n;

public class LanguageInfo {
    public static String getWikiLanguagePrefix(Locale locale) {
        String code = LanguageInfo.getJOSMLocaleCode(locale);
        if (code.length() == 2) {
            if (code.equals("en")) {
                return "";
            }
        } else if (!code.equals("zh_TW") && !code.equals("zh_CN")) {
            if (code.matches("[^_]+_[^_]+")) {
                if ((code = code.substring(0, 2)).equals("en")) {
                    return "";
                }
            } else {
                System.err.println(I18n.tr("Warning: failed to derive wiki language prefix from JOSM locale code ''{0}''. Using default code ''en''.", code));
                return "";
            }
        }
        return code.substring(0, 1).toUpperCase() + code.substring(1) + ":";
    }

    public static String getWikiLanguagePrefix() {
        return LanguageInfo.getWikiLanguagePrefix(Locale.getDefault());
    }

    public static String getJOSMLocaleCode() {
        return LanguageInfo.getJOSMLocaleCode(Locale.getDefault());
    }

    public static String getJOSMLocaleCode(Locale locale) {
        if (locale == null) {
            return "en";
        }
        String full = locale.toString();
        if (full.equals("iw_IL")) {
            return "he";
        }
        if (full.equals("en_GB") || full.equals("pt_BR") || full.equals("en_AU") || full.equals("zh_TW") || full.equals("zh_CN")) {
            return full;
        }
        return locale.getLanguage();
    }

    public static String getLanguageCodeXML() {
        return LanguageInfo.getJOSMLocaleCode() + ".";
    }

    public static String getLanguageCodeManifest() {
        return LanguageInfo.getJOSMLocaleCode() + "_";
    }
}

