/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetQuery {
    private Integer uid = null;
    private String userName = null;
    private Bounds bounds = null;
    private Date closedAfter = null;
    private Date createdBefore = null;
    private Boolean open = null;
    private Boolean closed = null;

    public static ChangesetQuery buildFromUrlQuery(String query) throws ChangesetQueryUrlException {
        return new ChangesetQueryUrlParser().parse(query);
    }

    public ChangesetQuery forUser(int uid) throws IllegalArgumentException {
        if (uid <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "uid", uid));
        }
        this.uid = uid;
        this.userName = null;
        return this;
    }

    public ChangesetQuery forUser(String username) {
        CheckParameterUtil.ensureParameterNotNull(username, "username");
        this.userName = username;
        this.uid = 0;
        return this;
    }

    public boolean isRestrictedToPartiallyIdentifiedUser() {
        return this.userName != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isRestrictedToFullyIdentifiedUser() {
        return this.uid > 0;
    }

    public ChangesetQuery inBbox(double minLon, double minLat, double maxLon, double maxLat) throws IllegalArgumentException {
        if (!LatLon.isValidLon(minLon)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "minLon", minLon));
        }
        if (!LatLon.isValidLon(maxLon)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLon", maxLon));
        }
        if (!LatLon.isValidLat(minLat)) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value for parameter ''{0}'', got {1}", "minLat", minLat));
        }
        if (!LatLon.isValidLat(maxLat)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLat", maxLat));
        }
        return this.inBbox(new LatLon(minLon, minLat), new LatLon(maxLon, maxLat));
    }

    public ChangesetQuery inBbox(LatLon min, LatLon max) {
        CheckParameterUtil.ensureParameterNotNull(min, "min");
        CheckParameterUtil.ensureParameterNotNull(max, "max");
        this.bounds = new Bounds(min, max);
        return this;
    }

    public ChangesetQuery inBbox(Bounds bbox) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(bbox, "bbox");
        this.bounds = bbox;
        return this;
    }

    public ChangesetQuery closedAfter(Date d) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(d, "d");
        this.closedAfter = d;
        return this;
    }

    public ChangesetQuery closedAfterAndCreatedBefore(Date closedAfter, Date createdBefore) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(closedAfter, "closedAfter");
        CheckParameterUtil.ensureParameterNotNull(createdBefore, "createdBefore");
        this.closedAfter = closedAfter;
        this.createdBefore = createdBefore;
        return this;
    }

    public ChangesetQuery beingOpen(boolean isOpen) {
        this.open = isOpen;
        return this;
    }

    public ChangesetQuery beingClosed(boolean isClosed) {
        this.closed = isClosed;
        return this;
    }

    public String getQueryString() {
        StringBuffer sb = new StringBuffer();
        if (this.uid != null) {
            sb.append("user").append("=").append(this.uid);
        } else if (this.userName != null) {
            sb.append("display_name").append("=").append(this.userName);
        }
        if (this.bounds != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("bbox=").append(this.bounds.encodeAsString(","));
        }
        if (this.closedAfter != null && this.createdBefore != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            sb.append("time").append("=").append(df.format(this.closedAfter));
            sb.append(",").append(df.format(this.createdBefore));
        } else if (this.closedAfter != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            sb.append("time").append("=").append(df.format(this.closedAfter));
        }
        if (this.open != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("open=").append(Boolean.toString(this.open));
        } else if (this.closed != null) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append("closed=").append(Boolean.toString(this.closed));
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangesetQueryUrlParser {
        protected int parseUid(String value) throws ChangesetQueryUrlException {
            int id;
            if (value == null || value.trim().equals("")) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value));
            }
            try {
                id = Integer.parseInt(value);
                if (id <= 0) {
                    throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value));
                }
            }
            catch (NumberFormatException e) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value));
            }
            return id;
        }

        protected boolean parseOpen(String value) throws ChangesetQueryUrlException {
            if (value == null || value.trim().equals("")) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "open", value));
            }
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
            throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "open", value));
        }

        protected boolean parseBoolean(String value, String parameter) throws ChangesetQueryUrlException {
            if (value == null || value.trim().equals("")) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
            }
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
            throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
        }

        protected Date parseDate(String value, String parameter) throws ChangesetQueryUrlException {
            if (value == null || value.trim().equals("")) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
            }
            if (value.endsWith("Z")) {
                value = value.substring(0, value.length() - 1) + "GMT+00:00";
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
            try {
                return formatter.parse(value);
            }
            catch (ParseException e) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
            }
        }

        protected Date[] parseTime(String value) throws ChangesetQueryUrlException {
            String[] dates = value.split(",");
            if (dates == null || dates.length == 0 || dates.length > 2) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "time", value));
            }
            if (dates.length == 1) {
                return new Date[]{this.parseDate(dates[0], "time")};
            }
            if (dates.length == 2) {
                return new Date[]{this.parseDate(dates[0], "time"), this.parseDate(dates[1], "time")};
            }
            return null;
        }

        protected ChangesetQuery crateFromMap(Map<String, String> queryParams) throws ChangesetQueryUrlException {
            ChangesetQuery csQuery = new ChangesetQuery();
            for (String k : queryParams.keySet()) {
                if (k.equals("uid")) {
                    if (queryParams.containsKey("display_name")) {
                        throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''"));
                    }
                    csQuery.forUser(this.parseUid(queryParams.get("uid")));
                    continue;
                }
                if (k.equals("display_name")) {
                    if (queryParams.containsKey("uid")) {
                        throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''"));
                    }
                    csQuery.forUser(queryParams.get("display_name"));
                    continue;
                }
                if (k.equals("open")) {
                    boolean b = this.parseBoolean(queryParams.get(k), "open");
                    csQuery.beingOpen(b);
                    continue;
                }
                if (k.equals("closed")) {
                    boolean b = this.parseBoolean(queryParams.get(k), "closed");
                    csQuery.beingClosed(b);
                    continue;
                }
                if (k.equals("time")) {
                    Date[] dates = this.parseTime(queryParams.get(k));
                    switch (dates.length) {
                        case 1: {
                            csQuery.closedAfter(dates[0]);
                            break;
                        }
                        case 2: {
                            csQuery.closedAfterAndCreatedBefore(dates[0], dates[1]);
                        }
                    }
                    continue;
                }
                if (k.equals("bbox")) {
                    try {
                        csQuery.inBbox(new Bounds(queryParams.get(k), ","));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ChangesetQueryUrlException(e);
                    }
                }
                throw new ChangesetQueryUrlException(I18n.tr("Unsupported parameter ''{0}'' in changeset query string", k));
            }
            return csQuery;
        }

        protected Map<String, String> createMapFromQueryString(String query) {
            String[] keyValuePairs;
            HashMap<String, String> queryParams = new HashMap<String, String>();
            for (String keyValuePair : keyValuePairs = query.split("&")) {
                String[] kv = keyValuePair.split("=");
                queryParams.put(kv[0], kv[1]);
            }
            return queryParams;
        }

        public ChangesetQuery parse(String query) throws ChangesetQueryUrlException {
            if (query == null) {
                return new ChangesetQuery();
            }
            if ((query = query.trim()).equals("")) {
                return new ChangesetQuery();
            }
            Map<String, String> queryParams = this.createMapFromQueryString(query);
            return this.crateFromMap(queryParams);
        }
    }

    public static class ChangesetQueryUrlException
    extends Exception {
        public ChangesetQueryUrlException() {
        }

        public ChangesetQueryUrlException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public ChangesetQueryUrlException(String arg0) {
            super(arg0);
        }

        public ChangesetQueryUrlException(Throwable arg0) {
            super(arg0);
        }
    }
}

