/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.AdvancedPreference;
import org.openstreetmap.josm.gui.preferences.AudioPreference;
import org.openstreetmap.josm.gui.preferences.BackupPreference;
import org.openstreetmap.josm.gui.preferences.ColorPreference;
import org.openstreetmap.josm.gui.preferences.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.LafPreference;
import org.openstreetmap.josm.gui.preferences.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.PluginPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceTabbedPane
extends JTabbedPane
implements MouseWheelListener {
    private static final Logger logger = Logger.getLogger(PreferenceTabbedPane.class.getName());
    private static final Collection<PreferenceSettingFactory> settingsFactory = new LinkedList<PreferenceSettingFactory>();
    private final List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    public final JPanel display = this.createPreferenceTab("display", I18n.tr("Display Settings"), I18n.tr("Various settings that influence the visual representation of the whole program."));
    public final JPanel connection = this.createPreferenceTab("connection", I18n.tr("Connection Settings"), I18n.tr("Connection Settings for the OSM server."), false);
    public final JPanel map = this.createPreferenceTab("map", I18n.tr("Map Settings"), I18n.tr("Settings for the map projection and data interpretation."));
    public final JPanel audio = this.createPreferenceTab("audio", I18n.tr("Audio Settings"), I18n.tr("Settings for the audio player and audio markers."));
    public final JPanel plugins = this.createPreferenceTab("plugin", I18n.tr("Plugins"), I18n.tr("Configure available plugins."), false);
    public final JTabbedPane displaycontent = new JTabbedPane();
    public final JTabbedPane mapcontent = new JTabbedPane();
    List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public JPanel createPreferenceTab(String icon, String title, String desc) {
        return this.createPreferenceTab(icon, title, desc, false);
    }

    public JPanel createPreferenceTab(String icon, String title, String desc, boolean inScrollPane) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add((Component)new JLabel(title), GBC.eol().insets(0, 5, 0, 10).anchor(18));
        JLabel descLabel = new JLabel("<html>" + desc + "</html>");
        descLabel.setFont(descLabel.getFont().deriveFont(2));
        p.add((Component)descLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        JComponent tab = p;
        if (inScrollPane) {
            JScrollPane sp = new JScrollPane(p);
            tab = sp;
        }
        this.addTab(null, ImageProvider.get("preferences", icon), tab);
        this.setToolTipTextAt(this.getTabCount() - 1, "<html>" + desc + "</html>");
        return p;
    }

    protected PluginPreference getPluginPreference() {
        for (PreferenceSetting setting : this.settings) {
            if (!(setting instanceof PluginPreference)) continue;
            return (PluginPreference)setting;
        }
        return null;
    }

    public void savePreferences() {
        if (Main.applet) {
            return;
        }
        PluginPreference preference = this.getPluginPreference();
        List<PluginInformation> toDownload = preference.getPluginsScheduledForUpdateOrDownload();
        final PluginDownloadTask task = !toDownload.isEmpty() ? new PluginDownloadTask((Component)this, toDownload, I18n.tr("Download plugins")) : null;
        final Runnable continuation = new Runnable(){

            public void run() {
                boolean requiresRestart = false;
                if (task != null && !task.isCanceled() && !task.getDownloadedPlugins().isEmpty()) {
                    requiresRestart = true;
                }
                for (PreferenceSetting setting : PreferenceTabbedPane.this.settings) {
                    if (!setting.ok()) continue;
                    requiresRestart = true;
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                if (task != null && !task.isCanceled()) {
                    sb.append(PluginPreference.buildDownloadSummary(task));
                }
                if (requiresRestart) {
                    sb.append(I18n.tr("You have to restart JOSM for some settings to take effect."));
                }
                sb.append("</html>");
                if (task != null && !task.isCanceled() || requiresRestart) {
                    JOptionPane.showMessageDialog(Main.parent, sb.toString(), I18n.tr("Warning"), 2);
                }
                Main.parent.repaint();
            }
        };
        if (task != null) {
            Main.worker.submit(task);
            Main.worker.submit(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(continuation);
                }
            });
        } else {
            continuation.run();
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(this);
    }

    public void buildGui() {
        for (PreferenceSettingFactory factory : settingsFactory) {
            PreferenceSetting setting = factory.createPreferenceSetting();
            if (setting == null) continue;
            this.settings.add(factory.createPreferenceSetting());
        }
        this.display.add((Component)this.displaycontent, GBC.eol().fill(1));
        this.map.add((Component)this.mapcontent, GBC.eol().fill(1));
        Iterator<PreferenceSetting> it = this.settings.iterator();
        while (it.hasNext()) {
            try {
                PreferenceSetting settings = it.next();
                settings.addGui(this);
            }
            catch (SecurityException e) {
                it.remove();
            }
            catch (Throwable e) {
                BugReportExceptionHandler.handleException(e);
            }
        }
    }

    public List<PreferenceSetting> getSettings() {
        return this.settings;
    }

    public <T> T getSetting(Class<? extends T> clazz) {
        for (PreferenceSetting setting : this.settings) {
            if (!clazz.isAssignableFrom(setting.getClass())) continue;
            return (T)setting;
        }
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent wev) {
        if (super.indexAtLocation(wev.getPoint().x, wev.getPoint().y) < 0) {
            return;
        }
        int newTab = super.getSelectedIndex() + wev.getWheelRotation();
        newTab = newTab < 0 ? 0 : newTab;
        newTab = newTab >= super.getTabCount() ? super.getTabCount() - 1 : newTab;
        super.setSelectedIndex(newTab);
    }

    static {
        settingsFactory.add(new DrawingPreference.Factory());
        settingsFactory.add(new ColorPreference.Factory());
        settingsFactory.add(new LafPreference.Factory());
        settingsFactory.add(new LanguagePreference.Factory());
        settingsFactory.add(new ServerAccessPreference.Factory());
        settingsFactory.add(new ProjectionPreference.Factory());
        settingsFactory.add(new MapPaintPreference.Factory());
        settingsFactory.add(new TaggingPresetPreference.Factory());
        settingsFactory.add(new BackupPreference.Factory());
        if (!Main.applet) {
            settingsFactory.add(new PluginPreference.Factory());
        }
        settingsFactory.add(Main.toolbar);
        settingsFactory.add(new AudioPreference.Factory());
        settingsFactory.add(new ShortcutPreference.Factory());
        PluginHandler.getPreferenceSetting(settingsFactory);
        settingsFactory.add(new AdvancedPreference.Factory());
    }

    public static interface ValidationListener {
        public boolean validatePreferences();
    }
}

