/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.LafPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LanguagePreference
implements PreferenceSetting {
    private JComboBox langCombo;
    private LanguageComboBoxModel model;

    public void addGui(PreferenceTabbedPane gui) {
        this.model = new LanguageComboBoxModel();
        this.langCombo = new JComboBox(this.model);
        this.langCombo.setRenderer(new LanguageCellRenderer(this.langCombo.getRenderer()));
        this.model.selectLanguage(Main.pref.get("language"));
        LafPreference lafPreference = gui.getSetting(LafPreference.class);
        JPanel panel = lafPreference.panel;
        panel.add((Component)new JLabel(I18n.tr("Language")), GBC.std().insets(20, 0, 0, 0));
        panel.add(GBC.glue(5, 0), GBC.std().fill(2));
        panel.add((Component)this.langCombo, GBC.eol().fill(2));
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    public boolean ok() {
        if (this.langCombo.getSelectedItem() == null) {
            return Main.pref.put("language", null);
        }
        return Main.pref.put("language", ((Locale)this.langCombo.getSelectedItem()).toString());
    }

    private static class LanguageCellRenderer
    extends DefaultListCellRenderer {
        private ListCellRenderer dispatch;

        public LanguageCellRenderer(ListCellRenderer dispatch) {
            this.dispatch = dispatch;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Locale l = (Locale)value;
            return this.dispatch.getListCellRendererComponent(list, l == null ? I18n.tr("Default (Auto determined)") : l.getDisplayName(l), index, isSelected, cellHasFocus);
        }
    }

    private static class LanguageComboBoxModel
    extends DefaultComboBoxModel {
        private final List<Locale> data = new ArrayList<Locale>();

        public LanguageComboBoxModel() {
            this.data.add(0, null);
            this.data.addAll(Arrays.asList(I18n.getAvailableTranslations()));
        }

        public void selectLanguage(String language) {
            this.setSelectedItem(null);
            if (language != null) {
                for (Locale locale : this.data) {
                    if (locale == null || !locale.toString().equals(language)) continue;
                    this.setSelectedItem(locale);
                    return;
                }
            }
        }

        public Object getElementAt(int index) {
            return this.data.get(index);
        }

        public int getSize() {
            return this.data.size();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new LanguagePreference();
        }
    }
}

