/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.FilterTableModel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDialog
extends ToggleDialog
implements DataSetListener {
    private JTable userTable;
    private FilterTableModel filterModel = new FilterTableModel();
    private SideButton addButton;
    private SideButton editButton;
    private SideButton deleteButton;
    private SideButton upButton;
    private SideButton downButton;
    protected String[] columnToolTips = new String[]{I18n.tr("Enable filter"), I18n.tr("Hide elements"), null, I18n.tr("Inverse filter"), I18n.tr("Filter mode")};

    public FilterDialog() {
        super(I18n.tr("Filter"), "filter", I18n.tr("Filter objects and hide/disable them."), Shortcut.registerShortcut("subwindow:filter", I18n.tr("Toggle: {0}", I18n.tr("Filter")), 70, 4, 1), 162);
        this.build();
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        this.filterModel.executeFilters();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this);
        this.filterModel.clearFilterFlags();
        Main.map.mapView.repaint();
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = this.getButtonPanel(5);
        this.addButton = new SideButton(I18n.marktr("Add"), "add", "SelectionList", I18n.tr("Add filter."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Filter filter = (Filter)SearchAction.showSearchDialog(new Filter());
                if (filter != null) {
                    FilterDialog.this.filterModel.addFilter(filter);
                }
            }
        });
        pnl.add(this.addButton);
        this.editButton = new SideButton(I18n.marktr("Edit"), "edit", "SelectionList", I18n.tr("Edit filter."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                Filter f = FilterDialog.this.filterModel.getFilter(index);
                Filter filter = (Filter)SearchAction.showSearchDialog(f);
                if (filter != null) {
                    FilterDialog.this.filterModel.setFilter(index, filter);
                }
            }
        });
        pnl.add(this.editButton);
        this.deleteButton = new SideButton(I18n.marktr("Delete"), "delete", "SelectionList", I18n.tr("Delete filter."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                FilterDialog.this.filterModel.removeFilter(index);
            }
        });
        pnl.add(this.deleteButton);
        this.upButton = new SideButton(I18n.marktr("Up"), "up", "SelectionList", I18n.tr("Move filter up."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                FilterDialog.this.filterModel.moveUpFilter(index);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(index - 1, index - 1);
            }
        });
        pnl.add(this.upButton);
        this.downButton = new SideButton(I18n.marktr("Down"), "down", "SelectionList", I18n.tr("Move filter down."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                FilterDialog.this.filterModel.moveDownFilter(index);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(index + 1, index + 1);
            }
        });
        pnl.add(this.downButton);
        return pnl;
    }

    protected void build() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        this.userTable = new JTable(this.filterModel){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return FilterDialog.this.columnToolTips[realIndex];
                    }
                };
            }
        };
        this.userTable.setSelectionMode(0);
        this.userTable.getColumnModel().getColumn(0).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(1).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(3).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(4).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(0).setResizable(false);
        this.userTable.getColumnModel().getColumn(1).setResizable(false);
        this.userTable.getColumnModel().getColumn(3).setResizable(false);
        this.userTable.getColumnModel().getColumn(4).setResizable(false);
        this.userTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.userTable.setDefaultRenderer(String.class, new StringRenderer());
        pnl.add((Component)new JScrollPane(this.userTable), "Center");
        pnl.add((Component)this.buildButtonRow(), "South");
        this.add((Component)pnl, "Center");
    }

    public void updateDialogHeader() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilterDialog.this.setTitle(I18n.tr("Filter Hidden:{0} Disabled:{1}", ((FilterDialog)FilterDialog.this).filterModel.disabledAndHiddenCount, ((FilterDialog)FilterDialog.this).filterModel.disabledCount));
            }
        });
    }

    public void drawOSDText(Graphics2D g) {
        this.filterModel.drawOSDText(g);
    }

    private Collection<OsmPrimitive> getAffectedPrimitives(Collection<? extends OsmPrimitive> primitives) {
        HashSet<OsmPrimitive> result = new HashSet<OsmPrimitive>();
        Stack<? extends OsmPrimitive> stack = new Stack<OsmPrimitive>();
        stack.addAll(primitives);
        while (!stack.isEmpty()) {
            OsmPrimitive p = (OsmPrimitive)stack.pop();
            if (result.contains(p)) continue;
            result.add(p);
            if (p instanceof Way) {
                for (Node n : ((Way)p).getNodes()) {
                    stack.push(n);
                }
            } else if (p instanceof Relation) {
                for (RelationMember rm : ((Relation)p).getMembers()) {
                    stack.push(rm.getMember());
                }
            }
            for (OsmPrimitive ref : p.getReferrers()) {
                stack.push(ref);
            }
        }
        return result;
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.filterModel.executeFilters();
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
        this.filterModel.executeFilters();
    }

    @Override
    public void primtivesAdded(PrimitivesAddedEvent event) {
        this.filterModel.executeFilters(event.getPrimitives());
    }

    @Override
    public void primtivesRemoved(PrimitivesRemovedEvent event) {
        this.filterModel.executeFilters();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(event.getPrimitives()));
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(event.getPrimitives()));
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(event.getPrimitives()));
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FilterTableModel model = (FilterTableModel)table.getModel();
            this.setSelected((Boolean)value);
            this.setEnabled(model.isCellEnabled(row, column));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FilterTableModel model = (FilterTableModel)table.getModel();
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setEnabled(model.isCellEnabled(row, column));
            return cell;
        }
    }
}

