/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairType;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListMergeModel<T>
extends Observable {
    public static final String FROZEN_PROP = ListMergeModel.class.getName() + ".frozen";
    private static final int MAX_DELETED_PRIMITIVE_IN_DIALOG = 5;
    protected HashMap<ListRole, ArrayList<T>> entries = new HashMap();
    protected DefaultTableModel myEntriesTableModel;
    protected DefaultTableModel theirEntriesTableModel;
    protected DefaultTableModel mergedEntriesTableModel;
    protected EntriesSelectionModel myEntriesSelectionModel;
    protected EntriesSelectionModel theirEntriesSelectionModel;
    protected EntriesSelectionModel mergedEntriesSelectionModel;
    private final List<PropertyChangeListener> listeners;
    private boolean isFrozen = false;
    private final ComparePairListModel comparePairListModel;

    protected abstract T cloneEntryForMergedList(T var1);

    public abstract boolean isEqualEntry(T var1, T var2);

    protected abstract void setValueAt(DefaultTableModel var1, Object var2, int var3, int var4);

    protected abstract OsmPrimitive getMyPrimitive(T var1);

    protected void buildMyEntriesTableModel() {
        this.myEntriesTableModel = new EntriesTableModel(ListRole.MY_ENTRIES);
    }

    protected void buildTheirEntriesTableModel() {
        this.theirEntriesTableModel = new EntriesTableModel(ListRole.THEIR_ENTRIES);
    }

    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new EntriesTableModel(ListRole.MERGED_ENTRIES);
    }

    protected List<T> getMergedEntries() {
        return this.entries.get((Object)ListRole.MERGED_ENTRIES);
    }

    protected List<T> getMyEntries() {
        return this.entries.get((Object)ListRole.MY_ENTRIES);
    }

    protected List<T> getTheirEntries() {
        return this.entries.get((Object)ListRole.THEIR_ENTRIES);
    }

    public int getMyEntriesSize() {
        return this.getMyEntries().size();
    }

    public int getMergedEntriesSize() {
        return this.getMergedEntries().size();
    }

    public int getTheirEntriesSize() {
        return this.getTheirEntries().size();
    }

    public ListMergeModel() {
        for (ListRole role : ListRole.values()) {
            this.entries.put(role, new ArrayList());
        }
        this.buildMyEntriesTableModel();
        this.buildTheirEntriesTableModel();
        this.buildMergedEntriesTableModel();
        this.myEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.MY_ENTRIES));
        this.theirEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.THEIR_ENTRIES));
        this.mergedEntriesSelectionModel = new EntriesSelectionModel(this.entries.get((Object)ListRole.MERGED_ENTRIES));
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.comparePairListModel = new ComparePairListModel();
        this.setFrozen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (listener != null && !this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (listener != null && this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFrozenChanged(boolean oldValue, boolean newValue) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, FROZEN_PROP, oldValue, newValue);
            for (PropertyChangeListener listener : this.listeners) {
                listener.propertyChange(evt);
            }
        }
    }

    public void setFrozen(boolean isFrozen) {
        boolean oldValue = this.isFrozen;
        this.isFrozen = isFrozen;
        this.fireFrozenChanged(oldValue, this.isFrozen);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public TableModel getMyTableModel() {
        return this.myEntriesTableModel;
    }

    public TableModel getTheirTableModel() {
        return this.theirEntriesTableModel;
    }

    public TableModel getMergedTableModel() {
        return this.mergedEntriesTableModel;
    }

    public EntriesSelectionModel getMySelectionModel() {
        return this.myEntriesSelectionModel;
    }

    public EntriesSelectionModel getTheirSelectionModel() {
        return this.theirEntriesSelectionModel;
    }

    public EntriesSelectionModel getMergedSelectionModel() {
        return this.mergedEntriesSelectionModel;
    }

    protected void fireModelDataChanged() {
        this.myEntriesTableModel.fireTableDataChanged();
        this.theirEntriesTableModel.fireTableDataChanged();
        this.mergedEntriesTableModel.fireTableDataChanged();
        this.setChanged();
        this.notifyObservers();
    }

    protected void copyToTop(ListRole role, int[] rows) {
        this.copy(role, rows, 0);
        this.mergedEntriesSelectionModel.setSelectionInterval(0, rows.length - 1);
    }

    public void copyMyToTop(int[] rows) {
        this.copyToTop(ListRole.MY_ENTRIES, rows);
    }

    public void copyTheirToTop(int[] rows) {
        this.copyToTop(ListRole.THEIR_ENTRIES, rows);
    }

    public void copyToEnd(ListRole source, int[] rows) {
        this.copy(source, rows, this.getMergedEntriesSize());
        this.mergedEntriesSelectionModel.setSelectionInterval(this.getMergedEntriesSize() - rows.length, this.getMergedEntriesSize() - 1);
    }

    public void copyMyToEnd(int[] rows) {
        this.copyToEnd(ListRole.MY_ENTRIES, rows);
    }

    public void copyTheirToEnd(int[] rows) {
        this.copyToEnd(ListRole.THEIR_ENTRIES, rows);
    }

    public void clearMerged() {
        this.getMergedEntries().clear();
        this.fireModelDataChanged();
    }

    protected void alertCopyFailedForDeletedPrimitives(List<PrimitiveId> deletedIds) {
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < Math.min(5, deletedIds.size()); ++i) {
            items.add(deletedIds.get(i).toString());
        }
        if (deletedIds.size() > 5) {
            items.add(I18n.tr("{0} more...", deletedIds.size() - 5));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(I18n.tr("The following primitives could not be copied to the target primitive<br>because they are deleted in the target dataset:"));
        sb.append("<ul>");
        for (String item : items) {
            sb.append("<li>").append(item).append("</li>");
        }
        sb.append("</ul>");
        sb.append("</html>");
        HelpAwareOptionPane.showOptionDialog(Main.parent, sb.toString(), I18n.tr("Merging deleted primitives failed"), 2, HelpUtil.ht("/Dialog/ConflictResolution#MergingDeletedPrimitivesFailed"));
    }

    private void copy(ListRole sourceRole, int[] rows, int position) {
        if (position < 0 || position > this.getMergedEntriesSize()) {
            throw new IllegalArgumentException();
        }
        ArrayList newItems = new ArrayList(rows.length);
        List source = this.entries.get((Object)sourceRole);
        ArrayList<PrimitiveId> deletedIds = new ArrayList<PrimitiveId>();
        for (int row : rows) {
            Object entry = source.get(row);
            OsmPrimitive primitive = this.getMyPrimitive(entry);
            if (!primitive.isDeleted()) {
                Object clone = this.cloneEntryForMergedList(entry);
                newItems.add(clone);
                continue;
            }
            deletedIds.add(primitive.getPrimitiveId());
        }
        this.getMergedEntries().addAll(position, newItems);
        this.fireModelDataChanged();
        if (!deletedIds.isEmpty()) {
            this.alertCopyFailedForDeletedPrimitives(deletedIds);
        }
    }

    public void copyAll(ListRole source) {
        this.getMergedEntries().clear();
        int[] rows = new int[this.entries.get((Object)source).size()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        this.copy(source, rows, 0);
    }

    protected void copyBeforeCurrent(ListRole source, int[] rows, int current) {
        this.copy(source, rows, current);
        this.mergedEntriesSelectionModel.setSelectionInterval(current, current + rows.length - 1);
    }

    public void copyMyBeforeCurrent(int[] rows, int current) {
        this.copyBeforeCurrent(ListRole.MY_ENTRIES, rows, current);
    }

    public void copyTheirBeforeCurrent(int[] rows, int current) {
        this.copyBeforeCurrent(ListRole.THEIR_ENTRIES, rows, current);
    }

    protected void copyAfterCurrent(ListRole source, int[] rows, int current) {
        this.copy(source, rows, current + 1);
        this.mergedEntriesSelectionModel.setSelectionInterval(current + 1, current + rows.length - 1);
        this.notifyObservers();
    }

    public void copyMyAfterCurrent(int[] rows, int current) {
        this.copyAfterCurrent(ListRole.MY_ENTRIES, rows, current);
    }

    public void copyTheirAfterCurrent(int[] rows, int current) {
        this.copyAfterCurrent(ListRole.THEIR_ENTRIES, rows, current);
    }

    public void moveUpMerged(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        if (rows[0] == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        for (int row : rows) {
            T n = mergedEntries.get(row);
            mergedEntries.remove(row);
            mergedEntries.add(row - 1, n);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
        for (int row : rows) {
            this.mergedEntriesSelectionModel.addSelectionInterval(row - 1, row - 1);
        }
    }

    public void moveDownMerged(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        if (rows[rows.length - 1] == mergedEntries.size() - 1) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            T n = mergedEntries.get(row);
            mergedEntries.remove(row);
            mergedEntries.add(row + 1, n);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
        for (int row : rows) {
            this.mergedEntriesSelectionModel.addSelectionInterval(row + 1, row + 1);
        }
    }

    public void removeMerged(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        List<T> mergedEntries = this.getMergedEntries();
        for (int i = rows.length - 1; i >= 0; --i) {
            mergedEntries.remove(rows[i]);
        }
        this.fireModelDataChanged();
        this.notifyObservers();
        this.mergedEntriesSelectionModel.clearSelection();
    }

    protected boolean myAndTheirEntriesEqual() {
        if (this.getMyEntries().size() != this.getTheirEntries().size()) {
            return false;
        }
        for (int i = 0; i < this.getMyEntries().size(); ++i) {
            if (this.isEqualEntry(this.getMyEntries().get(i), this.getTheirEntries().get(i))) continue;
            return false;
        }
        return true;
    }

    public ComparePairListModel getComparePairListModel() {
        return this.comparePairListModel;
    }

    public class ComparePairListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private int selectedIdx;
        private final ArrayList<ComparePairType> compareModes = new ArrayList();

        public ComparePairListModel() {
            this.compareModes.add(ComparePairType.MY_WITH_THEIR);
            this.compareModes.add(ComparePairType.MY_WITH_MERGED);
            this.compareModes.add(ComparePairType.THEIR_WITH_MERGED);
            this.selectedIdx = 0;
        }

        public Object getElementAt(int index) {
            if (index < this.compareModes.size()) {
                return this.compareModes.get(index);
            }
            throw new IllegalArgumentException(I18n.tr("Unexpected value of parameter ''index''. Got {0}.", index));
        }

        public int getSize() {
            return this.compareModes.size();
        }

        public Object getSelectedItem() {
            return this.compareModes.get(this.selectedIdx);
        }

        public void setSelectedItem(Object anItem) {
            int i = this.compareModes.indexOf(anItem);
            if (i < 0) {
                throw new IllegalStateException(I18n.tr("Item {0} not found in list.", anItem));
            }
            this.selectedIdx = i;
            ListMergeModel.this.fireModelDataChanged();
        }

        public ComparePairType getSelectedComparePair() {
            return this.compareModes.get(this.selectedIdx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntriesSelectionModel
    extends DefaultListSelectionModel {
        private final ArrayList<T> entries;

        public EntriesSelectionModel(ArrayList<T> nodes) {
            this.entries = nodes;
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (index0 > this.entries.size() - 1) {
                return;
            }
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.addSelectionInterval(index0, index1);
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
            if (this.entries.isEmpty()) {
                return;
            }
            if (before) {
                int newindex = Math.min(this.entries.size() - 1, index);
                if (newindex < index - length) {
                    return;
                }
                super.insertIndexInterval(newindex, length -= index - newindex, before);
            } else {
                if (index > this.entries.size() - 1) {
                    return;
                }
                length = Math.min(this.entries.size() - 1 - index, length);
                super.insertIndexInterval(index, length, before);
            }
        }

        @Override
        public void moveLeadSelectionIndex(int leadIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            leadIndex = Math.max(0, leadIndex);
            leadIndex = Math.min(this.entries.size() - 1, leadIndex);
            super.moveLeadSelectionIndex(leadIndex);
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.removeIndexInterval(index0, index1);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.removeSelectionInterval(index0, index1);
        }

        @Override
        public void setAnchorSelectionIndex(int anchorIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            anchorIndex = Math.min(this.entries.size() - 1, anchorIndex);
            super.setAnchorSelectionIndex(anchorIndex);
        }

        @Override
        public void setLeadSelectionIndex(int leadIndex) {
            if (this.entries.isEmpty()) {
                return;
            }
            leadIndex = Math.min(this.entries.size() - 1, leadIndex);
            super.setLeadSelectionIndex(leadIndex);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (this.entries.isEmpty()) {
                return;
            }
            index0 = Math.max(0, index0);
            index0 = Math.min(this.entries.size() - 1, index0);
            index1 = Math.max(0, index1);
            index1 = Math.min(this.entries.size() - 1, index1);
            super.setSelectionInterval(index0, index1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntriesTableModel
    extends DefaultTableModel {
        private final ListRole role;

        public EntriesTableModel(ListRole role) {
            this.role = role;
        }

        @Override
        public int getRowCount() {
            int count = Math.max(ListMergeModel.this.getMyEntries().size(), ListMergeModel.this.getMergedEntries().size());
            count = Math.max(count, ListMergeModel.this.getTheirEntries().size());
            return count;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < ListMergeModel.this.entries.get((Object)this.role).size()) {
                return ListMergeModel.this.entries.get((Object)this.role).get(row);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ListMergeModel.this.setValueAt(this, value, row, col);
        }

        public ListMergeModel<T> getListMergeModel() {
            return ListMergeModel.this;
        }

        public boolean isParticipatingInCurrentComparePair() {
            return ListMergeModel.this.getComparePairListModel().getSelectedComparePair().isParticipatingIn(this.role);
        }

        public boolean isSamePositionInOppositeList(int row) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (row >= this.getEntries().size()) {
                return false;
            }
            if (row >= this.getOppositeEntries().size()) {
                return false;
            }
            Object e1 = this.getEntries().get(row);
            Object e2 = this.getOppositeEntries().get(row);
            return ListMergeModel.this.isEqualEntry(e1, e2);
        }

        public boolean isIncludedInOppositeList(int row) {
            if (!this.isParticipatingInCurrentComparePair()) {
                throw new IllegalStateException(I18n.tr("List in role {0} is currently not participating in a compare pair.", this.role.toString()));
            }
            if (row >= this.getEntries().size()) {
                return false;
            }
            Object e1 = this.getEntries().get(row);
            for (Object e2 : this.getOppositeEntries()) {
                if (!ListMergeModel.this.isEqualEntry(e1, e2)) continue;
                return true;
            }
            return false;
        }

        protected ArrayList<T> getEntries() {
            return ListMergeModel.this.entries.get((Object)this.role);
        }

        protected ArrayList<T> getOppositeEntries() {
            ListRole opposite = ListMergeModel.this.getComparePairListModel().getSelectedComparePair().getOppositeRole(this.role);
            return ListMergeModel.this.entries.get((Object)opposite);
        }

        public ListRole getRole() {
            return this.role;
        }
    }
}

