/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ExtendedDialog
extends JDialog {
    private final boolean disposeOnClose;
    private int result = 0;
    public static final int DialogClosedOtherwise = 0;
    private boolean toggleable = false;
    private String rememberSizePref = "";
    private WindowGeometry defaultWindowGeometry = null;
    private String togglePref = "";
    private int toggleValue = -1;
    private String toggleCheckboxText = I18n.tr("Do not show again (remembers choice)");
    private JCheckBox toggleCheckbox = null;
    private Component parent;
    private Component content;
    private final String[] bTexts;
    private String[] bToolTipTexts;
    private Icon[] bIcons;
    private List<Integer> cancelButtonIdx = Collections.emptyList();
    private int defaultButtonIdx = 1;
    private JButton defaultButton = null;
    private Icon icon;
    private boolean modal;
    private boolean showHelpButton;
    private String helpTopic;
    private boolean placeContentInScrollPane;
    protected Insets contentInsets = new Insets(10, 5, 0, 5);
    protected ArrayList<JButton> buttons = new ArrayList();
    private boolean setupDone = false;

    public ExtendedDialog(Component parent, String title, String[] buttonTexts) {
        this(parent, title, buttonTexts, true, true);
    }

    public ExtendedDialog(Component parent, String title, String[] buttonTexts, boolean modal) {
        this(parent, title, buttonTexts, modal, true);
    }

    public ExtendedDialog(Component parent, String title, String[] buttonTexts, boolean modal, boolean disposeOnClose) {
        super((Window)JOptionPane.getFrameForComponent(parent), title, modal ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.MODELESS);
        this.parent = parent;
        this.modal = modal;
        this.bTexts = buttonTexts;
        if (disposeOnClose) {
            this.setDefaultCloseOperation(2);
        }
        this.disposeOnClose = disposeOnClose;
    }

    public ExtendedDialog setButtonIcons(Icon[] buttonIcons) {
        this.bIcons = buttonIcons;
        return this;
    }

    public ExtendedDialog setButtonIcons(String[] buttonIcons) {
        this.bIcons = new Icon[buttonIcons.length];
        for (int i = 0; i < buttonIcons.length; ++i) {
            this.bIcons[i] = ImageProvider.get(buttonIcons[i]);
        }
        return this;
    }

    public ExtendedDialog setToolTipTexts(String[] toolTipTexts) {
        this.bToolTipTexts = toolTipTexts;
        return this;
    }

    public ExtendedDialog setContent(Component content) {
        return this.setContent(content, true);
    }

    public ExtendedDialog setContent(Component content, boolean placeContentInScrollPane) {
        this.content = content;
        this.placeContentInScrollPane = placeContentInScrollPane;
        return this;
    }

    public ExtendedDialog setContent(String message) {
        return this.setContent(ExtendedDialog.string2label(message), false);
    }

    public ExtendedDialog setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public ExtendedDialog setIcon(int messageType) {
        switch (messageType) {
            case 0: {
                return this.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            }
            case 1: {
                return this.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
            }
            case 2: {
                return this.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            }
            case 3: {
                return this.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
            }
            case -1: {
                return this.setIcon(null);
            }
        }
        throw new IllegalArgumentException("Unknown message type!");
    }

    public ExtendedDialog showDialog() {
        if (this.toggleCheckState(this.togglePref)) {
            this.result = this.toggleValue;
            return this;
        }
        this.setupDialog();
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        this.fixFocus();
        this.setVisible(true);
        this.toggleSaveState();
        return this;
    }

    public int getValue() {
        return this.result;
    }

    public void setupDialog() {
        boolean limitedInHeight;
        if (this.setupDone) {
            return;
        }
        this.setupDone = true;
        this.setupEscListener();
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < this.bTexts.length; ++i) {
            final int final_i = i;
            AbstractAction action = new AbstractAction(this.bTexts[i]){

                public void actionPerformed(ActionEvent evt) {
                    ExtendedDialog.this.buttonAction(final_i, evt);
                }
            };
            JButton button = new JButton(action);
            if (i == this.defaultButtonIdx - 1) {
                this.defaultButton = button;
            }
            if (this.bIcons != null && this.bIcons[i] != null) {
                button.setIcon(this.bIcons[i]);
            }
            if (this.bToolTipTexts != null && i < this.bToolTipTexts.length && this.bToolTipTexts[i] != null) {
                button.setToolTipText(this.bToolTipTexts[i]);
            }
            buttonsPanel.add((Component)button, GBC.std().insets(2, 2, 2, 2));
            this.buttons.add(button);
        }
        if (this.showHelpButton) {
            buttonsPanel.add((Component)new JButton(new HelpAction()), GBC.std().insets(2, 2, 2, 2));
            HelpUtil.setHelpContext(this.getRootPane(), this.helpTopic);
        }
        JPanel cp = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        int y = 0;
        gc.gridy = y++;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        if (this.icon != null) {
            JLabel iconLbl = new JLabel(this.icon);
            gc.insets = new Insets(10, 10, 10, 10);
            gc.anchor = 11;
            gc.weighty = 1.0;
            cp.add((Component)iconLbl, gc);
            gc.anchor = 10;
            gc.gridx = 1;
        }
        gc.fill = 1;
        gc.insets = this.contentInsets;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        cp.add(this.content, gc);
        gc.fill = 0;
        gc.gridwidth = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        if (this.toggleable) {
            this.toggleCheckbox = new JCheckBox(this.toggleCheckboxText);
            boolean showDialog = Main.pref.getBoolean("message." + this.togglePref, true);
            this.toggleCheckbox.setSelected(!showDialog);
            gc.gridx = this.icon != null ? 1 : 0;
            gc.gridy = y++;
            gc.anchor = 21;
            gc.insets = new Insets(5, this.contentInsets.left, 5, this.contentInsets.right);
            cp.add((Component)this.toggleCheckbox, gc);
        }
        gc.gridy = y++;
        gc.anchor = 10;
        gc.insets = new Insets(5, 5, 5, 5);
        cp.add((Component)buttonsPanel, gc);
        if (this.placeContentInScrollPane) {
            JScrollPane pane = new JScrollPane(cp);
            pane.setBorder(null);
            this.setContentPane(pane);
        } else {
            this.setContentPane(cp);
        }
        this.pack();
        Dimension d = this.getSize();
        Dimension x = this.findMaxDialogSize();
        boolean limitedInWidth = d.width > x.width;
        boolean bl = limitedInHeight = d.height > x.height;
        if (x.width > 0 && d.width > x.width) {
            d.width = x.width;
        }
        if (x.height > 0 && d.height > x.height) {
            d.height = x.height;
        }
        if (!limitedInWidth && limitedInHeight) {
            d.width += new JScrollBar().getPreferredSize().width;
        }
        this.setSize(d);
        this.setLocationRelativeTo(this.parent);
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        this.result = buttonIndex + 1;
        this.setVisible(false);
    }

    protected Dimension findMaxDialogSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension x = new Dimension(screenSize.width * 2 / 3, screenSize.height * 2 / 3);
        try {
            if (this.parent != null) {
                x = JOptionPane.getFrameForComponent(this.parent).getSize();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return x;
    }

    private void setupEscListener() {
        AbstractAction actionListener = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedDialog.this.result = 0;
                ExtendedDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", actionListener);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.repaint();
        }
        if (this.rememberSizePref.length() != 0 && this.defaultWindowGeometry != null) {
            if (visible) {
                new WindowGeometry(this.rememberSizePref, this.defaultWindowGeometry).applySafe(this);
            } else {
                new WindowGeometry(this).remember(this.rememberSizePref);
            }
        }
        super.setVisible(visible);
        if (!visible && this.disposeOnClose) {
            this.dispose();
        }
    }

    public ExtendedDialog setRememberWindowGeometry(String pref, WindowGeometry wg) {
        this.rememberSizePref = pref == null ? "" : pref;
        this.defaultWindowGeometry = wg;
        return this;
    }

    public ExtendedDialog toggleEnable(String togglePref) {
        if (!this.modal) {
            throw new IllegalArgumentException();
        }
        this.toggleable = true;
        this.togglePref = togglePref;
        return this;
    }

    public ExtendedDialog toggleDisable() {
        this.toggleable = false;
        return this;
    }

    public ExtendedDialog setToggleCheckboxText(String text) {
        this.toggleCheckboxText = text;
        return this;
    }

    public ExtendedDialog setDefaultButton(int defaultButtonIdx) {
        this.defaultButtonIdx = defaultButtonIdx;
        return this;
    }

    public ExtendedDialog setCancelButton(Integer ... cancelButtonIdx) {
        this.cancelButtonIdx = Arrays.asList(cancelButtonIdx);
        return this;
    }

    protected void fixFocus() {
        if (this.toggleable && this.defaultButton != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExtendedDialog.this.defaultButton.requestFocusInWindow();
                }
            });
        }
    }

    private boolean toggleCheckState(String togglePref) {
        this.toggleable = togglePref != null && !togglePref.equals("");
        this.toggleValue = Main.pref.getInteger("message." + togglePref + ".value", -1);
        if (!this.toggleable || this.toggleValue == -1) {
            return false;
        }
        this.togglePref = togglePref;
        return !Main.pref.getBoolean("message." + togglePref, true);
    }

    private void toggleSaveState() {
        if (!this.toggleable || this.toggleCheckbox == null || this.cancelButtonIdx.contains(this.result) || this.result == 0) {
            return;
        }
        Main.pref.put("message." + this.togglePref, !this.toggleCheckbox.isSelected());
        Main.pref.putInteger("message." + this.togglePref + ".value", this.result);
    }

    private static JMultilineLabel string2label(String msg) {
        JMultilineLabel lbl = new JMultilineLabel(msg);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        lbl.setMaxWidth(screenSize.width / 2);
        return lbl;
    }

    public ExtendedDialog configureContextsensitiveHelp(String helpTopic, boolean showHelpButton) {
        this.helpTopic = helpTopic;
        this.showHelpButton = showHelpButton;
        return this;
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information"));
            this.putValue("Name", I18n.tr("Help"));
            this.putValue("SmallIcon", ImageProvider.get("help"));
        }

        public void actionPerformed(ActionEvent e) {
            HelpBrowser.setUrlForHelpTopic(ExtendedDialog.this.helpTopic);
        }
    }
}

