/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable {
    private Mode mode = Mode.select;
    private boolean alwaysCreateNodes = false;
    private long mouseDownTime = 0L;
    private WaySegment selectedSegment = null;
    private Color selectedColor;
    private List<EastNorth> possibleMoveDirections;
    private EastNorth activeMoveDirection;
    private Cursor oldCursor;
    private Point initialMousePos;
    private int initialMoveDelay = 200;
    private EastNorth initialN1en;
    private EastNorth initialN2en;
    private EastNorth newN1en;
    private EastNorth newN2en;
    private MoveCommand moveCommand;

    public ExtrudeAction(MapFrame mapFrame) {
        super(I18n.tr("Extrude"), "extrude/extrude", I18n.tr("Create areas"), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude")), 88, 3), mapFrame, ExtrudeAction.getCursor("normal", "rectangle", 0));
        this.putValue("help", "Action/Extrude/Extrude");
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.selectedColor = PaintColors.SELECTED.get();
    }

    public String getModeHelpText() {
        if (this.mode == Mode.translate) {
            return I18n.tr("Move a segment along its normal, then release the mouse button.");
        }
        if (this.mode == Mode.extrude) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.");
        }
        return I18n.tr("Drag a way segment to make a rectangle. Ctrl-drag to move a segment along its normal.");
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
    }

    public void exitMode() {
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        super.exitMode();
    }

    public void mousePressed(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(e.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (this.selectedSegment != null) {
            Node nextNode;
            if ((e.getModifiers() & 2) != 0) {
                this.mode = Mode.translate;
            } else {
                this.mode = Mode.extrude;
                this.getCurrentDataSet().setSelected(this.selectedSegment.way);
                this.alwaysCreateNodes = (e.getModifiers() & 1) != 0;
            }
            this.initialN1en = this.selectedSegment.getFirstNode().getEastNorth();
            this.initialN2en = this.selectedSegment.getSecondNode().getEastNorth();
            this.possibleMoveDirections = new ArrayList<EastNorth>();
            this.possibleMoveDirections.add(new EastNorth(this.initialN1en.getY() - this.initialN2en.getY(), this.initialN2en.getX() - this.initialN1en.getX()));
            Node prevNode = this.getPreviousNode(this.selectedSegment.lowerIndex);
            if (prevNode != null) {
                EastNorth en = prevNode.getEastNorth();
                this.possibleMoveDirections.add(new EastNorth(this.initialN1en.getX() - en.getX(), this.initialN1en.getY() - en.getY()));
            }
            if ((nextNode = this.getNextNode(this.selectedSegment.lowerIndex + 1)) != null) {
                EastNorth en = nextNode.getEastNorth();
                this.possibleMoveDirections.add(new EastNorth(this.initialN2en.getX() - en.getX(), this.initialN2en.getY() - en.getY()));
            }
            this.newN1en = null;
            this.newN2en = null;
            this.moveCommand = null;
            Main.map.mapView.addTemporaryLayer(this);
            this.updateStatusLine();
            Main.map.mapView.repaint();
            this.mouseDownTime = System.currentTimeMillis();
            this.initialMousePos = e.getPoint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.select) {
            EastNorth initialMouseEn = Main.map.mapView.getEastNorth(this.initialMousePos.x, this.initialMousePos.y);
            EastNorth mouseEn = Main.map.mapView.getEastNorth(e.getPoint().x, e.getPoint().y);
            EastNorth mouseMovement = new EastNorth(mouseEn.getX() - initialMouseEn.getX(), mouseEn.getY() - initialMouseEn.getY());
            double bestDistance = Double.POSITIVE_INFINITY;
            EastNorth bestMovement = null;
            this.activeMoveDirection = null;
            for (EastNorth direction : this.possibleMoveDirections) {
                double distanceFromMouseMovement;
                EastNorth movement = ExtrudeAction.calculateSegmentOffset(this.initialN1en, this.initialN2en, direction, mouseEn);
                if (movement == null || !(bestDistance > (distanceFromMouseMovement = movement.distance(mouseMovement)))) continue;
                bestDistance = distanceFromMouseMovement;
                this.activeMoveDirection = direction;
                bestMovement = movement;
            }
            this.newN1en = new EastNorth(this.initialN1en.getX() + bestMovement.getX(), this.initialN1en.getY() + bestMovement.getY());
            this.newN2en = new EastNorth(this.initialN2en.getX() + bestMovement.getX(), this.initialN2en.getY() + bestMovement.getY());
            double distance = Main.proj.eastNorth2latlon(this.initialN1en).greatCircleDistance(Main.proj.eastNorth2latlon(this.newN1en));
            Main.map.statusLine.setDist(distance);
            this.updateStatusLine();
            this.setCursor(Cursor.getPredefinedCursor(13));
            if (this.mode != Mode.extrude && this.mode == Mode.translate) {
                if (this.moveCommand == null) {
                    LinkedList<OsmPrimitive> nodelist = new LinkedList<OsmPrimitive>();
                    nodelist.add(this.selectedSegment.getFirstNode());
                    nodelist.add(this.selectedSegment.getSecondNode());
                    this.moveCommand = new MoveCommand(nodelist, bestMovement.getX(), bestMovement.getY());
                    Main.main.undoRedo.add(this.moveCommand);
                } else {
                    this.moveCommand.undoCommand();
                    this.moveCommand.moveAgain(bestMovement.getX(), bestMovement.getY());
                }
            }
            Main.map.mapView.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode != Mode.select) {
            if (this.mode == Mode.extrude) {
                if (e.getPoint().distance(this.initialMousePos) > 10.0 && this.newN1en != null) {
                    boolean nodeOverlapsSegment;
                    LinkedList<Command> cmds = new LinkedList<Command>();
                    Way wnew = new Way(this.selectedSegment.way);
                    int insertionPoint = this.selectedSegment.lowerIndex + 1;
                    Node prevNode = this.getPreviousNode(this.selectedSegment.lowerIndex);
                    boolean bl = nodeOverlapsSegment = prevNode != null && ExtrudeAction.pointsColinear(prevNode.getEastNorth(), this.initialN1en, this.newN1en);
                    if (nodeOverlapsSegment && !this.alwaysCreateNodes) {
                        Node n1Old = this.selectedSegment.getFirstNode();
                        cmds.add(new MoveCommand(n1Old, Main.proj.eastNorth2latlon(this.newN1en)));
                    } else {
                        Node n1New = new Node(Main.proj.eastNorth2latlon(this.newN1en));
                        wnew.addNode(insertionPoint, n1New);
                        ++insertionPoint;
                        cmds.add(new AddCommand(n1New));
                    }
                    Node nextNode = this.getNextNode(this.selectedSegment.lowerIndex + 1);
                    boolean bl2 = nodeOverlapsSegment = nextNode != null && ExtrudeAction.pointsColinear(nextNode.getEastNorth(), this.initialN2en, this.newN2en);
                    if (nodeOverlapsSegment && !this.alwaysCreateNodes) {
                        Node n2Old = this.selectedSegment.getSecondNode();
                        cmds.add(new MoveCommand(n2Old, Main.proj.eastNorth2latlon(this.newN2en)));
                    } else {
                        Node n2New = new Node(Main.proj.eastNorth2latlon(this.newN2en));
                        wnew.addNode(insertionPoint, n2New);
                        ++insertionPoint;
                        cmds.add(new AddCommand(n2New));
                    }
                    if (wnew.getNodesCount() == 4) {
                        wnew.addNode(this.selectedSegment.getFirstNode());
                    }
                    cmds.add(new ChangeCommand(this.selectedSegment.way, wnew));
                    SequenceCommand c = new SequenceCommand(I18n.tr("Extrude Way"), cmds);
                    Main.main.undoRedo.add(c);
                }
            } else if (this.mode == Mode.translate) {
                // empty if block
            }
            this.restoreCursor();
            Main.map.mapView.removeTemporaryLayer(this);
            this.selectedSegment = null;
            this.moveCommand = null;
            this.mode = Mode.select;
            this.updateStatusLine();
            Main.map.mapView.repaint();
        }
    }

    private static EastNorth calculateSegmentOffset(EastNorth segmentP1, EastNorth segmentP2, EastNorth moveDirection, EastNorth targetPos) {
        EastNorth intersectionPoint = ExtrudeAction.getLineLineIntersection(segmentP1, segmentP2, targetPos, new EastNorth(targetPos.getX() + moveDirection.getX(), targetPos.getY() + moveDirection.getY()));
        if (intersectionPoint == null) {
            return null;
        }
        return new EastNorth(targetPos.getX() - intersectionPoint.getX(), targetPos.getY() - intersectionPoint.getY());
    }

    public static EastNorth getLineLineIntersection(EastNorth p1, EastNorth p2, EastNorth p3, EastNorth p4) {
        double a1 = p2.getY() - p1.getY();
        double b1 = p1.getX() - p2.getX();
        double c1 = p2.getX() * p1.getY() - p1.getX() * p2.getY();
        double a2 = p4.getY() - p3.getY();
        double b2 = p3.getX() - p4.getX();
        double c2 = p4.getX() * p3.getY() - p3.getX() * p4.getY();
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        return new EastNorth((b1 * c2 - b2 * c1) / det, (a2 * c1 - a1 * c2) / det);
    }

    private static boolean pointsColinear(EastNorth p1, EastNorth p2, EastNorth p3) {
        double difference;
        double temp;
        double distance1 = p1.distance(p2);
        double distance2 = p1.distance(p3);
        double distance3 = p2.distance(p3);
        if (distance1 < distance2) {
            temp = distance1;
            distance1 = distance2;
            distance2 = temp;
        }
        if (distance1 < distance3) {
            temp = distance1;
            distance1 = distance3;
            distance3 = temp;
        }
        return Math.abs(difference = distance1 - distance2 - distance3) < 1.0E-15;
    }

    private Node getPreviousNode(int index) {
        if (index > 0) {
            return this.selectedSegment.way.getNode(index - 1);
        }
        if (this.selectedSegment.way.isClosed()) {
            return this.selectedSegment.way.getNode(this.selectedSegment.way.getNodesCount() - 2);
        }
        return null;
    }

    private Node getNextNode(int index) {
        int count = this.selectedSegment.way.getNodesCount();
        if (index < count - 1) {
            return this.selectedSegment.way.getNode(index + 1);
        }
        if (this.selectedSegment.way.isClosed()) {
            return this.selectedSegment.way.getNode(1);
        }
        return null;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (this.mode != Mode.select && this.newN1en != null) {
            Graphics2D g2 = g;
            g2.setColor(this.selectedColor);
            g2.setStroke(new BasicStroke(3.0f, 1, 1));
            Point p1 = mv.getPoint(this.initialN1en);
            Point p2 = mv.getPoint(this.initialN2en);
            Point p3 = mv.getPoint(this.newN1en);
            Point p4 = mv.getPoint(this.newN2en);
            if (this.mode == Mode.extrude) {
                GeneralPath b = new GeneralPath();
                b.moveTo(p1.x, p1.y);
                b.lineTo(p3.x, p3.y);
                b.lineTo(p4.x, p4.y);
                b.lineTo(p2.x, p2.y);
                b.lineTo(p1.x, p1.y);
                g2.draw(b);
                g2.setStroke(new BasicStroke(1.0f));
            } else if (this.mode == Mode.translate) {
                Line2D.Double newline = new Line2D.Double(p3, p4);
                g2.draw(newline);
                g2.setStroke(new BasicStroke(1.0f));
                Line2D.Double oldline = new Line2D.Double(p1, p2);
                g2.draw(oldline);
                if (this.activeMoveDirection != null) {
                    double fac = 1.0 / this.activeMoveDirection.distance(0.0, 0.0);
                    EastNorth normalUnitVector = new EastNorth(this.activeMoveDirection.getX() * fac, this.activeMoveDirection.getY() * fac);
                    if (this.newN1en != null && this.newN1en.getX() > this.initialN1en.getX() != normalUnitVector.getX() > -0.0) {
                        normalUnitVector = new EastNorth(-normalUnitVector.getX(), -normalUnitVector.getY());
                    }
                    normalUnitVector.setLocation(normalUnitVector.getX(), -normalUnitVector.getY());
                    Point2D.Double centerpoint = new Point2D.Double((p1.getX() + p2.getX()) * 0.5, (p1.getY() + p2.getY()) * 0.5);
                    Line2D normline = ExtrudeAction.createSemiInfiniteLine(centerpoint, normalUnitVector, g2);
                    g2.draw(normline);
                    if (this.activeMoveDirection == this.possibleMoveDirections.get(0)) {
                        double factor = 1.0 / g2.getTransform().getScaleX();
                        double raoffsetx = 8.0 * factor * normalUnitVector.getX();
                        double raoffsety = 8.0 * factor * normalUnitVector.getY();
                        Point2D.Double ra1 = new Point2D.Double(((Point2D)centerpoint).getX() + raoffsetx, ((Point2D)centerpoint).getY() + raoffsety);
                        Point2D.Double ra3 = new Point2D.Double(((Point2D)centerpoint).getX() - raoffsety, ((Point2D)centerpoint).getY() + raoffsetx);
                        Point2D.Double ra2 = new Point2D.Double(((Point2D)ra1).getX() - raoffsety, ((Point2D)ra1).getY() + raoffsetx);
                        GeneralPath ra = new GeneralPath();
                        ra.moveTo((float)((Point2D)ra1).getX(), (float)((Point2D)ra1).getY());
                        ra.lineTo((float)((Point2D)ra2).getX(), (float)((Point2D)ra2).getY());
                        ra.lineTo((float)((Point2D)ra3).getX(), (float)((Point2D)ra3).getY());
                        g2.draw(ra);
                    }
                }
            }
        }
    }

    private static Line2D createSemiInfiniteLine(Point2D start, Point2D unitvector, Graphics2D g) {
        Rectangle bounds = g.getDeviceConfiguration().getBounds();
        try {
            AffineTransform invtrans = g.getTransform().createInverse();
            Point2D widthpoint = invtrans.deltaTransform(new Point2D.Double(bounds.width, 0.0), null);
            Point2D heightpoint = invtrans.deltaTransform(new Point2D.Double(0.0, bounds.height), null);
            double linelength = Math.abs(widthpoint.getX()) + Math.abs(widthpoint.getY()) + Math.abs(heightpoint.getX()) + Math.abs(heightpoint.getY());
            return new Line2D.Double(start, new Point2D.Double(start.getX() + unitvector.getX() * linelength, start.getY() + unitvector.getY() * linelength));
        }
        catch (NoninvertibleTransformException e) {
            return new Line2D.Double(start, new Point2D.Double(start.getX() + unitvector.getX() * 10.0, start.getY() + unitvector.getY() * 10.0));
        }
    }

    private static Cursor getCursor(String name, String mod, int def) {
        try {
            return ImageProvider.getCursor(name, mod);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(def);
        }
    }

    private void setCursor(Cursor c) {
        if (this.oldCursor == null) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(c);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            Main.map.mapView.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        extrude,
        translate,
        select;

    }
}

