/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadPrimitiveTask
extends PleaseWaitRunnable {
    private DataSet ds;
    private boolean canceled;
    private Exception lastException;
    private PrimitiveId primitiveId;
    private OsmDataLayer layer;
    private OsmServerObjectReader reader;

    public DownloadPrimitiveTask(PrimitiveId id, OsmDataLayer layer) {
        super(I18n.tr("Download object"), false);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.primitiveId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        this.canceled = true;
        DownloadPrimitiveTask downloadPrimitiveTask = this;
        synchronized (downloadPrimitiveTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                DownloadPrimitiveTask.this.layer.mergeFrom(DownloadPrimitiveTask.this.ds);
                DownloadPrimitiveTask.this.layer.onPostDownloadFromServer();
                AutoScaleAction.zoomTo(DownloadPrimitiveTask.this.ds.allPrimitives());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.ds = new DataSet();
        try {
            DownloadPrimitiveTask downloadPrimitiveTask = this;
            synchronized (downloadPrimitiveTask) {
                if (this.canceled) {
                    return;
                }
                this.reader = new OsmServerObjectReader(this.primitiveId, true);
            }
            this.ds = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            downloadPrimitiveTask = this;
            synchronized (downloadPrimitiveTask) {
                this.reader = null;
            }
        }
        catch (Exception e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }
}

