/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.dbx.x86;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.dbx.DbxDebugger;
import sun.jvm.hotspot.debugger.dbx.x86.DbxX86ThreadContext;
import sun.jvm.hotspot.utilities.Assert;

public class DbxX86Thread
implements ThreadProxy {
    private DbxDebugger debugger;
    private int id;

    public DbxX86Thread(DbxDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.id = (int)addr.getCIntegerAt(0L, 4L, true);
    }

    public DbxX86Thread(DbxDebugger debugger, long id) {
        this.debugger = debugger;
        this.id = (int)id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DbxX86Thread)) {
            return false;
        }
        return ((DbxX86Thread)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public ThreadContext getContext() throws IllegalThreadStateException {
        DbxX86ThreadContext context = new DbxX86ThreadContext(this.debugger);
        long[] regs = this.debugger.getThreadIntegerRegisterSet(this.id);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regs.length == 19, "unknown size of register set -- adjust this code");
        }
        for (int i = 0; i < regs.length; ++i) {
            context.setRegister(i, regs[i]);
        }
        return context;
    }

    @Override
    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    @Override
    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public String toString() {
        return "t@" + this.id;
    }
}

