/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import sun.jvm.hotspot.CommandProcessor;
import sun.jvm.hotspot.HotSpotAgent;
import sun.jvm.hotspot.debugger.DebuggerException;

public class CLHSDB {
    private HotSpotAgent agent;
    private boolean attached;
    private String pidText;
    private int pid;
    private String execPath;
    private String coreFilename;

    public static void main(String[] args) {
        new CLHSDB(args).run();
    }

    private void run() {
        this.agent = new HotSpotAgent();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CLHSDB.this.detachDebugger();
            }
        });
        if (this.pidText != null) {
            this.attachDebugger(this.pidText);
        } else if (this.execPath != null) {
            this.attachDebugger(this.execPath, this.coreFilename);
        }
        CommandProcessor.DebuggerInterface di = new CommandProcessor.DebuggerInterface(){

            @Override
            public HotSpotAgent getAgent() {
                return CLHSDB.this.agent;
            }

            @Override
            public boolean isAttached() {
                return CLHSDB.this.attached;
            }

            @Override
            public void attach(String pid) {
                CLHSDB.this.attachDebugger(pid);
            }

            @Override
            public void attach(String java, String core) {
                CLHSDB.this.attachDebugger(java, core);
            }

            @Override
            public void detach() {
                CLHSDB.this.detachDebugger();
            }

            @Override
            public void reattach() {
                if (CLHSDB.this.attached) {
                    CLHSDB.this.detachDebugger();
                }
                if (CLHSDB.this.pidText != null) {
                    this.attach(CLHSDB.this.pidText);
                } else {
                    this.attach(CLHSDB.this.execPath, CLHSDB.this.coreFilename);
                }
            }
        };
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        CommandProcessor cp = new CommandProcessor(di, in, System.out, System.err);
        cp.run(true);
    }

    private void doUsage() {
        System.out.println("Usage:  java CLHSDB [[pid] | [path-to-java-executable [path-to-corefile]] | help ]");
        System.out.println("           pid:                     attach to the process whose id is 'pid'");
        System.out.println("           path-to-java-executable: Debug a core file produced by this program");
        System.out.println("           path-to-corefile:        Debug this corefile.  The default is 'core'");
        System.out.println("        If no arguments are specified, you can select what to do from the GUI.\n");
        HotSpotAgent.showUsage();
    }

    private CLHSDB(String[] args) {
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                if (args[0].equals("help") || args[0].equals("-help")) {
                    this.doUsage();
                    System.exit(0);
                }
                try {
                    int unused = Integer.parseInt(args[0]);
                    this.pidText = args[0];
                }
                catch (NumberFormatException e) {
                    this.execPath = args[0];
                    this.coreFilename = "core";
                }
                break;
            }
            case 2: {
                this.execPath = args[0];
                this.coreFilename = args[1];
                break;
            }
            default: {
                System.out.println("HSDB Error: Too many options specified");
                this.doUsage();
                System.exit(1);
            }
        }
    }

    private void attachDebugger(String pidText) {
        try {
            this.pidText = pidText;
            this.pid = Integer.parseInt(pidText);
        }
        catch (NumberFormatException e) {
            System.err.print("Unable to parse process ID \"" + pidText + "\".\nPlease enter a number.");
        }
        try {
            System.err.println("Attaching to process " + this.pid + ", please wait...");
            this.agent.attach(this.pid);
            this.attached = true;
        }
        catch (DebuggerException e) {
            String errMsg = this.formatMessage(e.getMessage(), 80);
            System.err.println("Unable to connect to process ID " + this.pid + ":\n\n" + errMsg);
            this.agent.detach();
            return;
        }
    }

    private void attachDebugger(String executablePath, String corePath) {
        try {
            System.err.println("Opening core file, please wait...");
            this.agent.attach(executablePath, corePath);
            this.attached = true;
        }
        catch (DebuggerException e) {
            String errMsg = this.formatMessage(e.getMessage(), 80);
            System.err.println("Unable to open core file\n" + corePath + ":\n\n" + errMsg);
            this.agent.detach();
            return;
        }
    }

    private void connect(String remoteMachineName) {
        try {
            System.err.println("Connecting to debug server, please wait...");
            this.agent.attach(remoteMachineName);
            this.attached = true;
        }
        catch (DebuggerException e) {
            String errMsg = this.formatMessage(e.getMessage(), 80);
            System.err.println("Unable to connect to machine \"" + remoteMachineName + "\":\n\n" + errMsg);
            this.agent.detach();
            return;
        }
    }

    private void detachDebugger() {
        if (!this.attached) {
            return;
        }
        this.agent.detach();
        this.attached = false;
    }

    private void detach() {
        this.detachDebugger();
    }

    private String formatMessage(String message, int charsPerLine) {
        StringBuffer buf = new StringBuffer(message.length());
        StringTokenizer tokenizer = new StringTokenizer(message);
        int curLineLength = 0;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (curLineLength + tok.length() > charsPerLine) {
                buf.append('\n');
                curLineLength = 0;
            } else if (curLineLength != 0) {
                buf.append(' ');
                ++curLineLength;
            }
            buf.append(tok);
            curLineLength += tok.length();
        }
        return buf.toString();
    }
}

