/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.lang.SerializationException;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static Object clone(Serializable object) {
        return SerializationUtils.deserialize(SerializationUtils.serialize(object));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Serializable obj, OutputStream outputStream) {
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(outputStream);
                out.writeObject(obj);
            }
            catch (IOException ex) {
                throw new SerializationException(ex);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        if (out == null) return;
        out.close();
        return;
    }

    public static byte[] serialize(Serializable obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializationUtils.serialize(obj, baos);
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(InputStream inputStream) {
        ObjectInputStream in = null;
        try {
            try {
                in = new ObjectInputStream(inputStream);
                Object object = in.readObject();
                Object var5_4 = null;
                try {
                    if (in == null) return object;
                    in.close();
                    return object;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return object;
            }
            catch (ClassNotFoundException ex) {
                throw new SerializationException(ex);
            }
            catch (IOException ex) {
                throw new SerializationException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {}
            catch (IOException ex) {
                throw throwable;
            }
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
    }

    public static Object deserialize(byte[] objectData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        return SerializationUtils.deserialize(bais);
    }
}

