/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IObjectFactory;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteResult;
import org.testng.SuiteRunState;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.internal.AnnotationTypeEnum;
import org.testng.internal.IInvoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.ThreadUtil;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteRunner
implements ISuite,
Serializable {
    private static final long serialVersionUID = 5284208932089503131L;
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private Map<String, ISuiteResult> m_suiteResults = new HashMap<String, ISuiteResult>();
    private transient List<TestRunner> m_testRunners = new ArrayList<TestRunner>();
    private transient List<ISuiteListener> m_listeners = new ArrayList<ISuiteListener>();
    private transient TestListenerAdapter m_textReporter = new TestListenerAdapter();
    private String m_outputDir;
    private XmlSuite m_suite;
    private transient List<ITestListener> m_testlisteners = new ArrayList<ITestListener>();
    private transient ITestRunnerFactory m_tmpRunnerFactory;
    private transient ITestRunnerFactory m_runnerFactory;
    private transient boolean m_useDefaultListeners = true;
    private String m_host;
    private transient IAnnotationFinder m_javadocAnnotationFinder;
    private transient IAnnotationFinder m_jdkAnnotationFinder;
    private transient IObjectFactory m_objectFactory;
    private transient Boolean m_skipFailedInvocationCounts = Boolean.FALSE;
    private IMethodInterceptor m_methodInterceptor;
    private List<IInvokedMethodListener> m_invokedMethodListeners;
    private SuiteRunState m_suiteState = new SuiteRunState();
    private Map<String, Object> m_attributes = new HashMap<String, Object>();

    public SuiteRunner(XmlSuite suite, String outputDir, IAnnotationFinder[] finders) {
        this(suite, outputDir, null, false, finders);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, IAnnotationFinder[] finders) {
        this(suite, outputDir, runnerFactory, false, finders);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, IAnnotationFinder[] finders) {
        this(suite, outputDir, runnerFactory, useDefaultListeners, finders, null, null, null);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, IAnnotationFinder[] finders, IObjectFactory factory, IMethodInterceptor methodInterceptor, List<IInvokedMethodListener> invokedMethodListener) {
        this.init(suite, outputDir, runnerFactory, useDefaultListeners, finders, factory, methodInterceptor, invokedMethodListener);
    }

    private void init(XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, IAnnotationFinder[] finders, IObjectFactory factory, IMethodInterceptor methodInterceptor, List<IInvokedMethodListener> invokedMethodListener) {
        this.m_suite = suite;
        this.m_useDefaultListeners = useDefaultListeners;
        this.m_tmpRunnerFactory = runnerFactory;
        this.m_methodInterceptor = methodInterceptor;
        if (null != finders) {
            this.m_javadocAnnotationFinder = finders[0];
            if (finders.length == 2) {
                this.m_jdkAnnotationFinder = finders[1];
            }
        }
        this.setOutputDir(outputDir);
        this.m_objectFactory = factory;
        if (this.m_objectFactory == null) {
            this.m_objectFactory = suite.getObjectFactory();
        }
        this.m_invokedMethodListeners = invokedMethodListener;
    }

    @Override
    public XmlSuite getXmlSuite() {
        return this.m_suite;
    }

    @Override
    public String getName() {
        return this.m_suite.getName();
    }

    public void setObjectFactory(IObjectFactory objectFactory) {
        this.m_objectFactory = objectFactory;
    }

    public void setTestListeners(List<ITestListener> testlisteners) {
        this.m_testlisteners = testlisteners;
    }

    public void setReportResults(boolean reportResults) {
        this.m_useDefaultListeners = reportResults;
    }

    private void invokeListeners(boolean start) {
        for (ISuiteListener sl : this.m_listeners) {
            if (start) {
                sl.onStart(this);
                continue;
            }
            sl.onFinish(this);
        }
    }

    private void setOutputDir(String outputdir) {
        if ((null == outputdir || "".equals(outputdir.trim())) && this.m_useDefaultListeners) {
            outputdir = DEFAULT_OUTPUT_DIR;
        }
        this.m_outputDir = null != outputdir ? new File(outputdir).getAbsolutePath() : null;
    }

    private void lazyInit() {
        this.m_runnerFactory = this.buildRunnerFactory(this.m_testlisteners);
    }

    protected ITestRunnerFactory buildRunnerFactory(List testListeners) {
        ITestRunnerFactory factory = null;
        factory = null == this.m_tmpRunnerFactory ? new DefaultTestRunnerFactory(this.m_testlisteners.toArray(new ITestListener[this.m_testlisteners.size()]), this.m_useDefaultListeners, this.m_skipFailedInvocationCounts) : new ProxyTestRunnerFactory(this.m_testlisteners.toArray(new ITestListener[this.m_testlisteners.size()]), this.m_tmpRunnerFactory);
        return factory;
    }

    @Override
    public String getParallel() {
        return this.m_suite.getParallel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.lazyInit();
        this.invokeListeners(true);
        try {
            this.privateRun();
            Object var2_1 = null;
            this.invokeListeners(false);
            if (this.m_suite.getVerbose() <= 0) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.invokeListeners(false);
            if (this.m_suite.getVerbose() <= 0) throw throwable;
            int total = this.m_textReporter.getAllTestMethods().length;
            List<ITestResult> skipped = this.m_textReporter.getSkippedTests();
            List<ITestResult> failed = this.m_textReporter.getFailedTests();
            int confFailures = this.m_textReporter.getConfigurationFailures().size();
            int confSkips = this.m_textReporter.getConfigurationSkips().size();
            StringBuffer bufLog = new StringBuffer(this.getName());
            bufLog.append("\nTotal tests run: ").append(total).append(", Failures: ").append(failed.size()).append(", Skips: ").append(skipped.size());
            if (confFailures > 0 || confSkips > 0) {
                bufLog.append("\nConfiguration Failures: ").append(confFailures).append(", Skips: ").append(confSkips);
            }
            System.out.println(new StringBuffer().append("\n===============================================\n").append(bufLog.toString()).append("\n===============================================\n").toString());
            throw throwable;
        }
        int total = this.m_textReporter.getAllTestMethods().length;
        List<ITestResult> skipped = this.m_textReporter.getSkippedTests();
        List<ITestResult> failed = this.m_textReporter.getFailedTests();
        int confFailures = this.m_textReporter.getConfigurationFailures().size();
        int confSkips = this.m_textReporter.getConfigurationSkips().size();
        StringBuffer bufLog = new StringBuffer(this.getName());
        bufLog.append("\nTotal tests run: ").append(total).append(", Failures: ").append(failed.size()).append(", Skips: ").append(skipped.size());
        if (confFailures > 0 || confSkips > 0) {
            bufLog.append("\nConfiguration Failures: ").append(confFailures).append(", Skips: ").append(confSkips);
        }
        System.out.println(new StringBuffer().append("\n===============================================\n").append(bufLog.toString()).append("\n===============================================\n").toString());
    }

    private void privateRun() {
        LinkedHashMap<Method, ITestNGMethod> beforeSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        LinkedHashMap<Method, ITestNGMethod> afterSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        IInvoker invoker = null;
        for (XmlTest test : this.m_suite.getTests()) {
            TestRunner tr = this.m_runnerFactory.newTestRunner(this, test, this.m_invokedMethodListeners);
            if (this.m_methodInterceptor != null) {
                tr.setMethodInterceptor(this.m_methodInterceptor);
            }
            tr.addListener(this.m_textReporter);
            this.m_testRunners.add(tr);
            invoker = tr.getInvoker();
            for (ITestNGMethod m : tr.getBeforeSuiteMethods()) {
                beforeSuiteMethods.put(m.getMethod(), m);
            }
            for (ITestNGMethod m : tr.getAfterSuiteMethods()) {
                afterSuiteMethods.put(m.getMethod(), m);
            }
        }
        if (invoker != null) {
            if (beforeSuiteMethods.values().size() > 0) {
                invoker.invokeConfigurations(null, beforeSuiteMethods.values().toArray(new ITestNGMethod[beforeSuiteMethods.size()]), this.m_suite, this.m_suite.getParameters(), null, null);
            }
            Utils.log("SuiteRunner", 3, new StringBuffer().append("Created ").append(this.m_testRunners.size()).append(" TestRunners").toString());
            boolean testsInParallel = "tests".equals(this.m_suite.getParallel());
            if (!testsInParallel) {
                this.runSequentially();
            } else {
                this.runConcurrently();
            }
            if (afterSuiteMethods.values().size() > 0) {
                invoker.invokeConfigurations(null, afterSuiteMethods.values().toArray(new ITestNGMethod[afterSuiteMethods.size()]), this.m_suite, this.m_suite.getAllParameters(), null, null);
            }
        }
    }

    private void runSequentially() {
        for (TestRunner tr : this.m_testRunners) {
            this.runTest(tr);
        }
    }

    private void runTest(TestRunner tr) {
        tr.run();
        SuiteResult sr = new SuiteResult(this.m_suite, (ITestContext)tr);
        this.m_suiteResults.put(tr.getName(), sr);
    }

    private void runConcurrently() {
        ArrayList<SuiteWorker> tasks = new ArrayList<SuiteWorker>(this.m_testRunners.size());
        for (TestRunner tr : this.m_testRunners) {
            tasks.add(new SuiteWorker(tr));
        }
        ThreadUtil.execute(tasks, this.m_suite.getThreadCount(), this.m_suite.getTimeOut((long)this.m_suite.getTests().size() * 1000L), false);
    }

    public void addListener(ISuiteListener reporter) {
        this.m_listeners.add(reporter);
    }

    @Override
    public String getOutputDirectory() {
        return new StringBuffer().append(this.m_outputDir).append(File.separatorChar).append(this.getName()).toString();
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.m_suiteResults;
    }

    @Override
    public String getParameter(String parameterName) {
        return this.m_suite.getParameter(parameterName);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        HashMap<String, Collection<ITestNGMethod>> result = new HashMap<String, Collection<ITestNGMethod>>();
        for (TestRunner tr : this.m_testRunners) {
            ITestNGMethod[] methods;
            for (ITestNGMethod m : methods = tr.getAllTestMethods()) {
                String[] groups;
                for (String groupName : groups = m.getGroups()) {
                    ArrayList<ITestNGMethod> testMethods = (ArrayList<ITestNGMethod>)result.get(groupName);
                    if (null == testMethods) {
                        testMethods = new ArrayList<ITestNGMethod>();
                        result.put(groupName, testMethods);
                    }
                    testMethods.add(m);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<ITestNGMethod> getInvokedMethods() {
        return this.getIncludedOrExcludedMethods(true);
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        return this.getIncludedOrExcludedMethods(false);
    }

    private Collection<ITestNGMethod> getIncludedOrExcludedMethods(boolean included) {
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        for (TestRunner tr : this.m_testRunners) {
            Collection<ITestNGMethod> methods = included ? tr.getInvokedMethods() : tr.getExcludedMethods();
            for (ITestNGMethod m : methods) {
                result.add(m);
            }
        }
        return result;
    }

    @Override
    public IObjectFactory getObjectFactory() {
        return this.m_objectFactory;
    }

    @Override
    public IAnnotationFinder getAnnotationFinder(String pAnnotationType) {
        AnnotationTypeEnum annotationType = AnnotationTypeEnum.valueOf(pAnnotationType);
        return annotationType == AnnotationTypeEnum.JDK ? this.m_jdkAnnotationFinder : this.m_javadocAnnotationFinder;
    }

    public static void ppp(String s) {
        System.out.println(new StringBuffer().append("[SuiteRunner] ").append(s).toString());
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public SuiteRunState getSuiteState() {
        return this.m_suiteState;
    }

    public void setSkipFailedInvocationCounts(Boolean skipFailedInvocationCounts) {
        if (skipFailedInvocationCounts != null) {
            this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.m_attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.put(name, value);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProxyTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private ITestRunnerFactory m_target;

        public ProxyTestRunnerFactory(ITestListener[] failureListeners, ITestRunnerFactory target) {
            this.m_failureGenerators = failureListeners;
            this.m_target = target;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, List<IInvokedMethodListener> listeners) {
            TestRunner testRunner = this.m_target.newTestRunner(suite, test, listeners);
            testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener itl : this.m_failureGenerators) {
                testRunner.addListener(itl);
            }
            return testRunner;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private boolean m_useDefaultListeners;
        private boolean m_skipFailedInvocationCounts;

        public DefaultTestRunnerFactory(ITestListener[] failureListeners, boolean useDefaultListeners, boolean skipFailedInvocationCounts) {
            this.m_failureGenerators = failureListeners;
            this.m_useDefaultListeners = useDefaultListeners;
            this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, List<IInvokedMethodListener> listeners) {
            boolean skip = this.m_skipFailedInvocationCounts;
            if (!skip) {
                skip = test.skipFailedInvocationCounts();
            }
            TestRunner testRunner = new TestRunner(suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(test.getAnnotations()), skip, listeners);
            if (this.m_useDefaultListeners) {
                testRunner.addListener(new TestHTMLReporter());
                testRunner.addListener(new JUnitXMLReporter());
                testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            }
            for (ITestListener itl : this.m_failureGenerators) {
                testRunner.addListener(itl);
            }
            return testRunner;
        }
    }

    private class SuiteWorker
    implements Runnable {
        private TestRunner m_testRunner;

        public SuiteWorker(TestRunner tr) {
            this.m_testRunner = tr;
        }

        public void run() {
            Utils.log("[SuiteWorker]", 4, "Running XML Test '" + this.m_testRunner.getTest().getName() + "' in Parallel");
            SuiteRunner.this.runTest(this.m_testRunner);
        }
    }
}

