/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.status.StatusMessageParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.DualListener;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.RangeProgressViewer;
import org.netbeans.lib.cvsclient.progress.receiving.FileInfoAndMessageResponseProgressHandler;
import org.netbeans.lib.cvsclient.progress.sending.FileStateRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public final class StatusCommand
extends AbstractCommand {
    @NonNls
    static final String EXAM_DIR = "server: Examining ";
    private boolean includeTags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        ICvsFiles cvsFiles;
        try {
            cvsFiles = this.scanFileSystem(this.getFileObjects(), clientEnvironment);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        Requests requests = new Requests(CommandRequest.STATUS, clientEnvironment);
        requests.addArgumentRequest(this.includeTags, "-v");
        this.addFileRequests(cvsFiles, requests, clientEnvironment);
        requests.addLocalPathDirectoryRequest();
        this.addArgumentRequests(requests);
        FileStateRequestsProgressHandler requestsProgressHandler = new FileStateRequestsProgressHandler(new RangeProgressViewer(progressViewer, 0.0, 0.5), cvsFiles);
        FileInfoAndMessageResponseProgressHandler responseProgressHandler = new FileInfoAndMessageResponseProgressHandler(new RangeProgressViewer(progressViewer, 0.5, 1.0), cvsFiles, EXAM_DIR);
        StatusMessageParser statusMessageParser = new StatusMessageParser(eventSender, this.getFileObjects().getFileObjects(), clientEnvironment.getCvsFileSystem());
        DualListener listener = new DualListener(statusMessageParser, responseProgressHandler);
        listener.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, requestsProgressHandler);
            return bl;
        }
        finally {
            listener.unregisterListeners(listenerRegistry);
        }
    }

    @Override
    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
        this.setIncludeTags(false);
    }

    @Override
    public String getCvsCommandLine() {
        StringBuffer cvsCommand = new StringBuffer("status ");
        cvsCommand.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommand);
        return cvsCommand.toString();
    }

    private boolean isIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(boolean includeTags) {
        this.includeTags = includeTags;
    }

    private String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.isIncludeTags()) {
            toReturn.append("-v ");
        }
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        return toReturn.toString();
    }
}

