/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsLog;

import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.LogMessageParser;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.DummyRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public class RlogCommand
extends AbstractCommand {
    private String myModuleName = ".";
    private boolean myHeadersOnly = true;
    private boolean myNoTags = false;
    private String myDateTo;
    private String myDateFrom;
    private boolean mySuppressEmptyHeaders = true;
    private String myBranchName = null;
    private boolean myLogDefaultBranch = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        Requests requests = new Requests(CommandRequest.RLOG, clientEnvironment);
        requests.addArgumentRequest(this.myHeadersOnly, "-h");
        requests.addArgumentRequest(this.myNoTags, "-N");
        requests.addArgumentRequest(this.mySuppressEmptyHeaders, "-S");
        requests.addArgumentRequest(!this.isRecursive(), "-l");
        requests.addArgumentRequest(this.getDateFilter(), "-d");
        if (this.myBranchName != null) {
            requests.addArgumentRequest("-r" + this.myBranchName);
        }
        requests.addArgumentRequest(this.myLogDefaultBranch, "-b");
        requests.addArgumentRequest(this.myModuleName);
        LogMessageParser parser = new LogMessageParser(eventSender, clientEnvironment.getCvsFileSystem());
        parser.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, new DummyRequestsProgressHandler());
            return bl;
        }
        finally {
            parser.unregisterListeners(listenerRegistry);
        }
    }

    public void setMyLogDefaultBranch(boolean logDefaultBranch) {
        this.myLogDefaultBranch = logDefaultBranch;
    }

    @Nullable
    private String getDateFilter() {
        if (this.myDateFrom == null && this.myDateTo == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (this.myDateFrom == null) {
            result.append('<');
            result.append(this.myDateTo);
        } else if (this.myDateTo == null) {
            result.append('>');
            result.append(this.myDateFrom);
        } else {
            result.append(this.myDateFrom);
            result.append('<');
            result.append(this.myDateTo);
        }
        return result.toString();
    }

    @Override
    public final String getCvsCommandLine() {
        StringBuffer cvsCommandLine = new StringBuffer("rlog ");
        cvsCommandLine.append(this.getCVSArguments());
        this.appendFileArguments(cvsCommandLine);
        return cvsCommandLine.toString();
    }

    @Override
    public final void resetCvsCommand() {
        super.resetCvsCommand();
        this.setRecursive(true);
    }

    public void setHeadersOnly(boolean headersOnly) {
        this.myHeadersOnly = headersOnly;
    }

    public void setNoTags(boolean noTags) {
        this.myNoTags = noTags;
    }

    private String getCVSArguments() {
        StringBuffer cvsArguments = new StringBuffer();
        if (this.myHeadersOnly) {
            cvsArguments.append("-h ");
        }
        if (this.myNoTags) {
            cvsArguments.append("-N ");
        }
        return cvsArguments.toString();
    }

    public void setModuleName(String moduleName) {
        this.myModuleName = moduleName;
    }

    @Override
    protected final void addModifiedRequest(FileObject fileObject, Entry entry, Requests requests, IClientEnvironment clientEnvironment) {
        requests.addIsModifiedRequest(fileObject);
    }

    public void setDateFrom(String dateFrom) {
        this.myDateFrom = dateFrom;
    }

    public void setDateTo(String dateTo) {
        this.myDateTo = dateTo;
    }

    public void setSuppressEmptyHeaders(boolean suppressEmptyHeaders) {
        this.mySuppressEmptyHeaders = suppressEmptyHeaders;
    }

    public void setBranchName(String branchName) {
        this.myBranchName = branchName;
    }
}

