/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class TypeParameterHidesVisibleTypeInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.hides.visible.type.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/TypeParameterHidesVisibleTypeInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("type.parameter.hides.visible.type.problem.descriptor", aClass.getQualifiedName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/TypeParameterHidesVisibleTypeInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeParameterHidesVisibleTypeVisitor();
    }

    private static class TypeParameterHidesVisibleTypeVisitor
    extends BaseInspectionVisitor {
        private TypeParameterHidesVisibleTypeVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            String unqualifiedClassName = parameter.getName();
            JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)parameter.getProject());
            PsiFile containingFile = parameter.getContainingFile();
            PsiResolveHelper resolveHelper = manager.getResolveHelper();
            PsiClass aClass = resolveHelper.resolveReferencedClass(unqualifiedClassName, (PsiElement)containingFile);
            if (aClass == null) {
                return;
            }
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            this.registerError((PsiElement)identifier, aClass);
        }
    }
}

