/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesPackageLocalMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("MethodOverridesPrivateMethodOfSuperclass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverridesPackageLocalMethodInspection.getID must not return null");
        }
        return "MethodOverridesPrivateMethodOfSuperclass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.overrides.package.local.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverridesPackageLocalMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.overrides.package.local.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/MethodOverridesPackageLocalMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesPrivateMethodVisitor();
    }

    private static class MethodOverridesPrivateMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesPrivateMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/visibility/MethodOverridesPackageLocalMethodInspection$MethodOverridesPrivateMethodVisitor.visitMethod must not be null");
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                String ancestorPackageName;
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                PsiMethod overridingMethod = ancestorClass.findMethodBySignature(method, true);
                if (overridingMethod == null || !overridingMethod.hasModifierProperty("packageLocal")) continue;
                PsiJavaFile file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiJavaFile.class);
                if (file == null) {
                    return;
                }
                PsiJavaFile ancestorFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)ancestorClass, PsiJavaFile.class);
                if (ancestorFile == null) {
                    return;
                }
                String packageName = file.getPackageName();
                if (packageName.equals(ancestorPackageName = ancestorFile.getPackageName())) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }
    }
}

