/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InnerClassVariableHidesOuterClassVariableInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @NotNull
    public String getID() {
        if ("InnerClassFieldHidesOuterClassField" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/InnerClassVariableHidesOuterClassVariableInspection.getID must not return null");
        }
        return "InnerClassFieldHidesOuterClassField";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inner.class.field.hides.outer.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/InnerClassVariableHidesOuterClassVariableInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inner.class.field.hides.outer.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/InnerClassVariableHidesOuterClassVariableInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inner.class.field.hides.outer.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInvisibleFields");
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassVariableHidesOuterClassVariableVisitor();
    }

    private class InnerClassVariableHidesOuterClassVariableVisitor
    extends BaseInspectionVisitor {
        private InnerClassVariableHidesOuterClassVariableVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/visibility/InnerClassVariableHidesOuterClassVariableInspection$InnerClassVariableHidesOuterClassVariableVisitor.visitField must not be null");
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName)) {
                return;
            }
            boolean reportStaticsOnly = false;
            if (aClass.hasModifierProperty("static")) {
                reportStaticsOnly = true;
            }
            PsiClass ancestorClass = ClassUtils.getContainingClass((PsiElement)aClass);
            while (ancestorClass != null) {
                PsiField ancestorField = ancestorClass.findFieldByName(fieldName, false);
                if (!(ancestorField == null || InnerClassVariableHidesOuterClassVariableInspection.this.m_ignoreInvisibleFields && reportStaticsOnly && !field.hasModifierProperty("static"))) {
                    this.registerFieldError(field, new Object[0]);
                }
                ancestorClass = ClassUtils.getContainingClass((PsiElement)ancestorClass);
            }
        }
    }
}

