/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SynchronizedOnLiteralObjectInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronized.on.literal.object.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizedOnLiteralObjectInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("synchronized.on.literal.object.descriptor", type.getPresentableText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizedOnLiteralObjectInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLiteralVisitor();
    }

    private static class SynchronizeOnLiteralVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLiteralVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/SynchronizedOnLiteralObjectInspection$SynchronizeOnLiteralVisitor.visitSynchronizedStatement must not be null");
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression = statement.getLockExpression();
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return;
            }
            if (!SynchronizeOnLiteralVisitor.isNumberOrStringType(lockExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            PsiExpression initializer = variable.getInitializer();
            if (!(initializer instanceof PsiLiteralExpression)) {
                return;
            }
            this.registerError((PsiElement)lockExpression, lockExpression.getType());
        }

        public static boolean isNumberOrStringType(PsiExpression expression) {
            PsiType type = expression.getType();
            if (type == null) {
                return false;
            }
            Project project = expression.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass javaLangNumberClass = psiFacade.findClass("java.lang.Number", expression.getResolveScope());
            if (javaLangNumberClass == null) {
                return false;
            }
            PsiElementFactory elementFactory = psiFacade.getElementFactory();
            PsiClassType javaLangNumberType = elementFactory.createType(javaLangNumberClass);
            return type.equalsToText("java.lang.String") || type.equalsToText("java.lang.Boolean") || type.equalsToText("java.lang.Character") || javaLangNumberType.isAssignableFrom(type);
        }
    }
}

