/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import org.jetbrains.annotations.NotNull;

public class PublicFieldAccessedInSynchronizedContextInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.field.accessed.in.synchronized.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/PublicFieldAccessedInSynchronizedContextInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("NonPrivateFieldAccessedInSynchronizedContext" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/PublicFieldAccessedInSynchronizedContextInspection.getID must not return null");
        }
        return "NonPrivateFieldAccessedInSynchronizedContext";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.field.accessed.in.synchronized.context.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/PublicFieldAccessedInSynchronizedContextInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicFieldAccessedInSynchronizedContextVisitor();
    }

    private static class PublicFieldAccessedInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private PublicFieldAccessedInSynchronizedContextVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/PublicFieldAccessedInSynchronizedContextInspection$PublicFieldAccessedInSynchronizedContextVisitor.visitReferenceExpression must not be null");
            }
            PsiElement element = expression.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("private") || field.hasModifierProperty("final")) {
                return;
            }
            if (!SynchronizationUtil.isInSynchronizedContext((PsiElement)expression)) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass.hasModifierProperty("private")) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

