/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.WellFormednessUtils;
import org.jetbrains.annotations.NotNull;

public class ArithmeticOnVolatileFieldInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("arithmetic.on.volatile.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ArithmeticOnVolatileFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("arithmetic.on.volatile.field.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ArithmeticOnVolatileFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AritmeticOnVolatileFieldInspection();
    }

    private static class AritmeticOnVolatileFieldInspection
    extends BaseInspectionVisitor {
        private AritmeticOnVolatileFieldInspection() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/ArithmeticOnVolatileFieldInspection$AritmeticOnVolatileFieldInspection.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!(JavaTokenType.ASTERISK.equals(tokenType) || JavaTokenType.DIV.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType) || JavaTokenType.MINUS.equals(tokenType) || JavaTokenType.PERC.equals(tokenType))) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            this.checkForVolatile(lhs);
            PsiExpression rhs = expression.getROperand();
            this.checkForVolatile(rhs);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/ArithmeticOnVolatileFieldInspection$AritmeticOnVolatileFieldInspection.visitAssignmentExpression must not be null");
            }
            super.visitAssignmentExpression(expression);
            if (!WellFormednessUtils.isWellFormed(expression)) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!(JavaTokenType.ASTERISKEQ.equals(tokenType) || JavaTokenType.DIVEQ.equals(tokenType) || JavaTokenType.PLUSEQ.equals(tokenType) || JavaTokenType.MINUSEQ.equals(tokenType) || JavaTokenType.PERCEQ.equals(tokenType))) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            this.checkForVolatile(lhs);
            PsiExpression rhs = expression.getRExpression();
            this.checkForVolatile(rhs);
        }

        private void checkForVolatile(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (field.hasModifierProperty("volatile")) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }
    }
}

