/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ControlFlowStatementWithoutBracesInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ControlFlowStatementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ControlFlowStatementVisitor();
    }

    private static class ControlFlowStatementVisitor
    extends BaseInspectionVisitor {
        private ControlFlowStatementVisitor() {
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            PsiStatement body = statement.getBody();
            if (body == null || body instanceof PsiBlockStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            PsiStatement body = statement.getBody();
            if (body == null || body instanceof PsiBlockStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitForStatement(PsiForStatement statement) {
            super.visitForStatement(statement);
            PsiStatement body = statement.getBody();
            if (body == null || body instanceof PsiBlockStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        public void visitIfStatement(PsiIfStatement statement) {
            PsiStatement elseBranch;
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (!(thenBranch instanceof PsiBlockStatement)) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            }
            if ((elseBranch = statement.getElseBranch()) == null) {
                return;
            }
            if (!(elseBranch instanceof PsiBlockStatement) && !(elseBranch instanceof PsiIfStatement)) {
                PsiKeyword elseKeyword = statement.getElseElement();
                if (elseKeyword == null) {
                    return;
                }
                this.registerError((PsiElement)elseKeyword, new Object[0]);
            }
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            PsiStatement body = statement.getBody();
            if (body == null || body instanceof PsiBlockStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }

    private static class ControlFlowStatementFix
    extends InspectionGadgetsFix {
        private ControlFlowStatementFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("control.flow.statement.without.braces.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ControlFlowStatementWithoutBracesInspection$ControlFlowStatementFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiStatement statementWithoutBraces;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiStatement)) {
                return;
            }
            PsiStatement statement = (PsiStatement)parent;
            String elementText = element.getText();
            if (statement instanceof PsiLoopStatement) {
                PsiLoopStatement loopStatement = (PsiLoopStatement)statement;
                statementWithoutBraces = loopStatement.getBody();
            } else if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                if ("if".equals(elementText)) {
                    statementWithoutBraces = ifStatement.getThenBranch();
                    if (statementWithoutBraces == null) {
                        return;
                    }
                    PsiElement nextSibling = statementWithoutBraces.getNextSibling();
                    if (nextSibling instanceof PsiWhiteSpace) {
                        nextSibling.delete();
                    }
                } else {
                    statementWithoutBraces = ifStatement.getElseBranch();
                }
            } else {
                return;
            }
            if (statementWithoutBraces == null) {
                return;
            }
            String newStatementText = "{\n" + statementWithoutBraces.getText() + "\n}";
            ControlFlowStatementFix.replaceStatement(statementWithoutBraces, newStatementText);
        }
    }
}

