/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspection;
import org.jetbrains.annotations.NotNull;

public class NonSerializableFieldInSerializableClassInspection
extends SerializableInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.serializable.field.in.serializable.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableFieldInSerializableClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.serializable.field.in.serializable.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableFieldInSerializableClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableFieldInSerializableClassVisitor();
    }

    private class NonSerializableFieldInSerializableClassVisitor
    extends BaseInspectionVisitor {
        private NonSerializableFieldInSerializableClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/NonSerializableFieldInSerializableClassInspection$NonSerializableFieldInSerializableClassVisitor.visitField must not be null");
            }
            if (field.hasModifierProperty("transient") || field.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            if (SerializationUtils.isProbablySerializable(field.getType())) {
                return;
            }
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (hasWriteObject) {
                return;
            }
            if (NonSerializableFieldInSerializableClassInspection.this.isIgnoredSubclass(aClass)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

