/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class ExternalizableWithSerializationMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ExternalizableClassWithSerializationMethods" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/ExternalizableWithSerializationMethodsInspection.getID must not return null");
        }
        return "ExternalizableClassWithSerializationMethods";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("externalizable.with.serialization.methods.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/ExternalizableWithSerializationMethodsInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        if (hasReadObject && hasWriteObject) {
            string = InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.both", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/ExternalizableWithSerializationMethodsInspection.buildErrorString must not return null");
            return string;
        }
        if (hasWriteObject) {
            string = InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.write", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/ExternalizableWithSerializationMethodsInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("externalizable.with.serialization.methods.problem.descriptor.read", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/ExternalizableWithSerializationMethodsInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExternalizableDefinesSerializationMethodsVisitor();
    }

    private static class ExternalizableDefinesSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private ExternalizableDefinesSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/serialization/ExternalizableWithSerializationMethodsInspection$ExternalizableDefinesSerializationMethodsVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!SerializationUtils.isExternalizable(aClass)) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (!hasWriteObject && !hasReadObject) {
                return;
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject);
        }
    }
}

