/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class CustomClassloaderInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("custom.classloader.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/CustomClassloaderInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("custom.classloader.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/CustomClassloaderInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CustomClassloaderVisitor();
    }

    private static class CustomClassloaderVisitor
    extends BaseInspectionVisitor {
        private CustomClassloaderVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/security/CustomClassloaderInspection$CustomClassloaderVisitor.visitClass must not be null");
            }
            if (!ClassUtils.isSubclass(aClass, "java.lang.ClassLoader")) {
                return;
            }
            if ("java.lang.ClassLoader".equals(aClass.getQualifiedName())) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

