/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NotNull;

public class SocketResourceInspection
extends ResourceInspection {
    @NotNull
    public String getID() {
        if ("SocketOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/SocketResourceInspection.getID must not return null");
        }
        return "SocketOpenedButNotSafelyClosed";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("socket.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/SocketResourceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/SocketResourceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SocketResourceVisitor();
    }

    private static class SocketResourceVisitor
    extends BaseInspectionVisitor {
        private SocketResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/SocketResourceInspection$SocketResourceVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!SocketResourceVisitor.isSocketFactoryMethod(expression)) {
                return;
            }
            PsiElement parent = ResourceInspection.getExpressionParent((PsiExpression)expression);
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(parent);
            if (ResourceInspection.isSafelyClosed(boundVariable, (PsiExpression)expression)) {
                return;
            }
            if (ResourceInspection.isResourceEscapedFromMethod(boundVariable, (PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/SocketResourceInspection$SocketResourceVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            if (!SocketResourceVisitor.isSocketResource(expression)) {
                return;
            }
            PsiElement parent = ResourceInspection.getExpressionParent((PsiExpression)expression);
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(parent);
            if (ResourceInspection.isSafelyClosed(boundVariable, (PsiExpression)expression)) {
                return;
            }
            if (ResourceInspection.isResourceEscapedFromMethod(boundVariable, (PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static boolean isSocketResource(PsiNewExpression expression) {
            return TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression, "java.net.Socket", "java.net.DatagramSocket", "java.net.ServerSocket") != null;
        }

        private static boolean isSocketFactoryMethod(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"accept".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.net.ServerSocket");
        }
    }
}

