/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static boolean isSerializable(@Nullable PsiClass aClass) {
        return ClassUtils.isSubclass(aClass, "java.io.Serializable");
    }

    public static boolean isExternalizable(@Nullable PsiClass aClass) {
        return ClassUtils.isSubclass(aClass, "java.io.Externalizable");
    }

    public static boolean isDirectlySerializable(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SerializationUtils.isDirectlySerializable must not be null");
        }
        PsiReferenceList implementsList = aClass.getImplementsList();
        if (implementsList != null) {
            PsiJavaCodeReferenceElement[] interfaces;
            for (PsiJavaCodeReferenceElement aInterfaces : interfaces = implementsList.getReferenceElements()) {
                String name;
                PsiClass implemented = (PsiClass)aInterfaces.resolve();
                if (implemented == null || !"java.io.Serializable".equals(name = implemented.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasReadObject(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SerializationUtils.hasReadObject must not be null");
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("readObject", false)) {
            if (!SerializationUtils.isReadObject(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWriteObject(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SerializationUtils.hasWriteObject must not be null");
        }
        for (PsiMethod method : methods = aClass.findMethodsByName("writeObject", false)) {
            if (!SerializationUtils.isWriteObject(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReadObject(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SerializationUtils.isReadObject must not be null");
        }
        PsiManager manager = method.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        Project project = method.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClassType type = factory.createTypeByFQClassName("java.io.ObjectInputStream", scope);
        return MethodUtils.methodMatches(method, null, PsiType.VOID, "readObject", new PsiType[]{type});
    }

    public static boolean isWriteObject(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SerializationUtils.isWriteObject must not be null");
        }
        PsiManager manager = method.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        Project project = method.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClassType type = factory.createTypeByFQClassName("java.io.ObjectOutputStream", scope);
        return MethodUtils.methodMatches(method, null, PsiType.VOID, "writeObject", new PsiType[]{type});
    }

    public static boolean isReadResolve(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SerializationUtils.isReadResolve must not be null");
        }
        return MethodUtils.simpleMethodMatches(method, null, "java.lang.Object", "readResolve", new String[0]);
    }

    public static boolean isWriteReplace(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/SerializationUtils.isWriteReplace must not be null");
        }
        return MethodUtils.simpleMethodMatches(method, null, "java.lang.Object", "writeReplace", new String[0]);
    }

    public static boolean isProbablySerializable(PsiType type) {
        if (type instanceof PsiWildcardType) {
            return true;
        }
        if (type instanceof PsiPrimitiveType) {
            return true;
        }
        if (type instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)type).getComponentType();
            return SerializationUtils.isProbablySerializable(componentType);
        }
        if (type instanceof PsiClassType) {
            PsiClassType classTYpe = (PsiClassType)type;
            PsiClass psiClass = classTYpe.resolve();
            if (SerializationUtils.isSerializable(psiClass)) {
                return true;
            }
            if (SerializationUtils.isExternalizable(psiClass)) {
                return true;
            }
            if (ClassUtils.isSubclass(psiClass, "java.util.Collection") || ClassUtils.isSubclass(psiClass, "java.util.Map")) {
                PsiType[] parameters;
                for (PsiType parameter : parameters = classTYpe.getParameters()) {
                    if (SerializationUtils.isProbablySerializable(parameter)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

