/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantStringFormatCallInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.string.format.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/RedundantStringFormatCallInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.string.format.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/RedundantStringFormatCallInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantStringFormatCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantStringFormatCallVisitor();
    }

    private static class RedundantStringFormatCallVisitor
    extends BaseInspectionVisitor {
        private RedundantStringFormatCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiLiteralExpression literalExpression;
            String expressionText;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"format".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 2 || arguments.length == 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReference)) {
                return;
            }
            PsiReference referenceExpression = (PsiReference)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            String className = aClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType firstType = firstArgument.getType();
            if (firstType == null) {
                return;
            }
            if (firstArgument instanceof PsiLiteralExpression && (expressionText = (literalExpression = (PsiLiteralExpression)firstArgument).getText()).contains("%n")) {
                return;
            }
            if (firstType.equalsToText("java.lang.String") && arguments.length == 1) {
                this.registerMethodCallError(expression, new Object[0]);
            } else if (firstType.equalsToText("java.util.Locale")) {
                if (arguments.length != 2) {
                    return;
                }
                PsiExpression secondArgument = arguments[1];
                PsiType secondType = secondArgument.getType();
                if (secondType == null) {
                    return;
                }
                if (secondType.equalsToText("java.lang.String")) {
                    this.registerMethodCallError(expression, new Object[0]);
                }
            }
        }
    }

    private static class RedundantStringFormatCallFix
    extends InspectionGadgetsFix {
        private RedundantStringFormatCallFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("redundant.string.format.call.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/RedundantStringFormatCallInspection$RedundantStringFormatCallFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression lastArgument = arguments[arguments.length - 1];
            methodCallExpression.replace((PsiElement)lastArgument);
        }
    }
}

