/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallToSimpleSetterInClassInspection
extends BaseInspection {
    public boolean ignoreSetterCallsOnOtherObjects = false;

    @NotNull
    public String getID() {
        if ("CallToSimpleSetterFromWithinClass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CallToSimpleSetterInClassInspection.getID must not return null");
        }
        return "CallToSimpleSetterFromWithinClass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.simple.setter.in.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CallToSimpleSetterInClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.simple.setter.in.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CallToSimpleSetterInClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("call.to.simple.setter.in.class.display.name.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSetterCallsOnOtherObjects");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new InlineCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSimpleSetterInClassVisitor();
    }

    private class CallToSimpleSetterInClassVisitor
    extends BaseInspectionVisitor {
        private CallToSimpleSetterInClassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/CallToSimpleSetterInClassInspection$CallToSimpleSetterInClassVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(call);
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)call);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!containingClass.equals(method.getContainingClass())) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                if (CallToSimpleSetterInClassInspection.this.ignoreSetterCallsOnOtherObjects) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType = (PsiClassType)type;
                PsiClass qualifierClass = classType.resolve();
                if (!containingClass.equals(qualifierClass)) {
                    return;
                }
            }
            if (!MethodUtils.isSimpleSetter(method)) {
                return;
            }
            Query query = OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true);
            PsiMethod overridingMethod = (PsiMethod)query.findFirst();
            if (overridingMethod != null) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }
    }

    private static class InlineCallFix
    extends InspectionGadgetsFix {
        private InlineCallFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("call.to.simple.setter.in.class.inline.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/CallToSimpleSetterInClassInspection$InlineCallFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodIdentifier = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodIdentifier.getParent();
            if (methodExpression == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)methodExpression.getParent();
            if (call == null) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression argument = arguments[0];
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)statements[0];
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiReferenceExpression lhs = (PsiReferenceExpression)assignment.getLExpression();
            PsiField field = (PsiField)lhs.resolve();
            if (field == null) {
                return;
            }
            String fieldName = field.getName();
            if (qualifier == null) {
                JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)call.getProject());
                PsiResolveHelper resolveHelper = manager.getResolveHelper();
                PsiVariable variable = resolveHelper.resolveReferencedVariable(fieldName, (PsiElement)call);
                if (variable == null) {
                    return;
                }
                String newExpression = variable.equals(field) ? fieldName + " = " + argument.getText() : "this." + fieldName + " = " + argument.getText();
                InlineCallFix.replaceExpression((PsiExpression)call, newExpression);
            } else {
                String newExpression = qualifier.getText() + '.' + fieldName + " = " + argument.getText();
                InlineCallFix.replaceExpression((PsiExpression)call, newExpression);
            }
        }
    }
}

