/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUnconnectedToPackageInspection
extends BaseGlobalInspection {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.PACKAGING_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/packaging/ClassUnconnectedToPackageInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope analysisScope, InspectionManager inspectionManager, GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        PsiClass aClass = refClass.getElement();
        if (ClassUtils.isInnerClass(aClass)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        for (RefClass dependency : dependencies) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, dependency)) continue;
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, dependent)) continue;
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("class.unconnected.to.package.problem.descriptor", refEntity.getName());
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    private static boolean inSamePackage(RefClass class1, RefClass class2) {
        RefPackage package1 = RefJavaUtil.getPackage((RefEntity)class1);
        RefPackage package2 = RefJavaUtil.getPackage((RefEntity)class2);
        if (package1 == null || package2 == null) {
            return false;
        }
        String name1 = package1.getQualifiedName();
        String name2 = package2.getQualifiedName();
        return name1 != null && name2 != null && name1.equals(name2);
    }
}

