/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class ComparisonToNaNInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("comparison.to.nan.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/ComparisonToNaNInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiBinaryExpression comparison = (PsiBinaryExpression)infos[0];
        PsiJavaToken sign = comparison.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            string = InspectionGadgetsBundle.message("comparison.to.nan.problem.descriptor1", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/ComparisonToNaNInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("comparison.to.nan.problem.descriptor2", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/ComparisonToNaNInspection.buildErrorString must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ComparisonToNaNVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ComparisonToNaNFix();
    }

    private static class ComparisonToNaNVisitor
    extends BaseInspectionVisitor {
        private ComparisonToNaNVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/ComparisonToNaNInspection$ComparisonToNaNVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (!ComparisonToNaNVisitor.isFloatingPointType(lhs) && !ComparisonToNaNVisitor.isFloatingPointType(rhs)) {
                return;
            }
            if (ComparisonToNaNVisitor.isNaN(lhs)) {
                this.registerError((PsiElement)lhs, expression);
            } else if (rhs != null && ComparisonToNaNVisitor.isNaN(rhs)) {
                this.registerError((PsiElement)rhs, expression);
            }
        }

        private static boolean isFloatingPointType(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return false;
            }
            return PsiType.DOUBLE.equals(type) || PsiType.FLOAT.equals(type);
        }

        private static boolean isNaN(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            String referenceName = referenceExpression.getReferenceName();
            if (!"NaN".equals(referenceName)) {
                return false;
            }
            PsiElement qualifier = referenceExpression.getQualifier();
            if (qualifier == null) {
                return false;
            }
            String qualifierText = qualifier.getText();
            return "Double".equals(qualifierText) || "Float".equals(qualifierText);
        }
    }

    private static class ComparisonToNaNFix
    extends InspectionGadgetsFix {
        private ComparisonToNaNFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("comparison.to.nan.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/ComparisonToNaNInspection$ComparisonToNaNFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression NaNExpression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiElement qualifier = NaNExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            String typeString = qualifier.getText();
            PsiBinaryExpression comparison = (PsiBinaryExpression)NaNExpression.getParent();
            PsiExpression lhs = comparison.getLOperand();
            PsiExpression rhs = comparison.getROperand();
            PsiExpression operand = NaNExpression.equals(lhs) ? rhs : lhs;
            assert (operand != null);
            String operandText = operand.getText();
            PsiJavaToken sign = comparison.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            String negationString = tokenType.equals(JavaTokenType.EQEQ) ? "" : "!";
            String newExpressionText = negationString + typeString + ".isNaN(" + operandText + ')';
            ComparisonToNaNFix.replaceExpression((PsiExpression)comparison, newExpressionText);
        }
    }
}

