/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import org.jetbrains.annotations.NotNull;

public class ClassWithoutToStringInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.without.tostring.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/maturity/ClassWithoutToStringInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.without.tostring.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/maturity/ClassWithoutToStringInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutToStringVisitor();
    }

    private static class ClassWithoutToStringVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutToStringVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/maturity/ClassWithoutToStringInspection$ClassWithoutToStringVisitor.visitClass must not be null");
            }
            if (aClass.getNameIdentifier() == null && !(aClass instanceof PsiAnonymousClass)) {
                return;
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            for (PsiMethod method : methods = aClass.findMethodsByName("toString", false)) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 0) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

