/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.RegExInputVerifier;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class PublicMethodWithoutLoggingInspection
extends BaseInspection {
    public String loggerClassName = "java.util.logging.Logger";

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.method.without.logging.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/PublicMethodWithoutLoggingInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.method.without.logging.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/PublicMethodWithoutLoggingInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        JLabel classNameLabel = new JLabel(InspectionGadgetsBundle.message("logger.name.option", new Object[0]));
        classNameLabel.setHorizontalAlignment(11);
        final JTextField loggerClassNameField = new JTextField();
        Font panelFont = panel.getFont();
        loggerClassNameField.setFont(panelFont);
        loggerClassNameField.setText(this.loggerClassName);
        loggerClassNameField.setColumns(100);
        loggerClassNameField.setInputVerifier(new RegExInputVerifier());
        DocumentListener listener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            private void textChanged() {
                PublicMethodWithoutLoggingInspection.this.loggerClassName = loggerClassNameField.getText();
            }
        };
        Document loggerClassNameDocument = loggerClassNameField.getDocument();
        loggerClassNameDocument.addDocumentListener(listener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 13;
        constraints.fill = 2;
        panel.add((Component)classNameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        panel.add((Component)loggerClassNameField, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodWithoutLoggingVisitor();
    }

    private class ContainsLoggingCallVisitor
    extends JavaRecursiveElementVisitor {
        private boolean containsLoggingCall = false;

        private ContainsLoggingCallVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/logging/PublicMethodWithoutLoggingInspection$ContainsLoggingCallVisitor.visitElement must not be null");
            }
            if (this.containsLoggingCall) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/logging/PublicMethodWithoutLoggingInspection$ContainsLoggingCallVisitor.visitMethodCallExpression must not be null");
            }
            if (this.containsLoggingCall) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            if (containingClassName == null) {
                return;
            }
            if (containingClassName.equals(PublicMethodWithoutLoggingInspection.this.loggerClassName)) {
                this.containsLoggingCall = true;
            }
        }

        public boolean containsLoggingCall() {
            return this.containsLoggingCall;
        }
    }

    private class PublicMethodWithoutLoggingVisitor
    extends BaseInspectionVisitor {
        private PublicMethodWithoutLoggingVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/logging/PublicMethodWithoutLoggingInspection$PublicMethodWithoutLoggingVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            if (method.getBody() == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            if (PropertyUtil.isSimplePropertyAccessor((PsiMethod)method)) {
                return;
            }
            if (this.containsLoggingCall(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean containsLoggingCall(PsiMethod method) {
            ContainsLoggingCallVisitor visitor = new ContainsLoggingCallVisitor();
            method.accept((PsiElementVisitor)visitor);
            return visitor.containsLoggingCall();
        }
    }
}

