/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.RegExInputVerifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class ClassWithoutLoggerInspection
extends BaseInspection {
    public String loggerClassName = "java.util.logging.Logger";
    public boolean ignoreSuperLoggers = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("no.logger.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/ClassWithoutLoggerInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("no.logger.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/ClassWithoutLoggerInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithoutLoggerVisitor();
    }

    private class Form {
        private JPanel contentPanel;
        private JTextField loggerClassNameTextField;
        private JCheckBox ignoreCheckBox;

        Form() {
            this.$$$setupUI$$$();
            this.loggerClassNameTextField.setText(ClassWithoutLoggerInspection.this.loggerClassName);
            this.loggerClassNameTextField.setInputVerifier(new RegExInputVerifier());
            DocumentListener listener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.textChanged();
                }

                private void textChanged() {
                    ClassWithoutLoggerInspection.this.loggerClassName = Form.this.loggerClassNameTextField.getText();
                }
            };
            Document document = this.loggerClassNameTextField.getDocument();
            document.addDocumentListener(listener);
            this.ignoreCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ClassWithoutLoggerInspection.this.ignoreSuperLoggers = Form.this.ignoreCheckBox.isSelected();
                }
            });
        }

        public JPanel getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), 0, 4, false, false));
            this.loggerClassNameTextField = jTextField = new JTextField();
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(100, -1), new Dimension(150, -1), null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("logger.name.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.ignoreCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("super.class.logger.option"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 9, 0, 3, 0, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class ClassWithoutLoggerVisitor
    extends BaseInspectionVisitor {
        private ClassWithoutLoggerVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/logging/ClassWithoutLoggerInspection$ClassWithoutLoggerVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            PsiField[] fields = ClassWithoutLoggerInspection.this.ignoreSuperLoggers ? aClass.getAllFields() : aClass.getFields();
            for (PsiField field : fields) {
                if (!this.isLogger(field) || !PsiUtil.isAccessible((PsiMember)field, (PsiElement)aClass, (PsiClass)aClass)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean isLogger(PsiField field) {
            PsiType type = field.getType();
            String text = type.getCanonicalText();
            return text.equals(ClassWithoutLoggerInspection.this.loggerClassName);
        }
    }
}

