/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCaseWithNoTestMethodsInspection
extends BaseInspection {
    public boolean ignoreSupers = false;

    @NotNull
    public String getID() {
        if ("JUnitTestCaseWithNoTests" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseWithNoTestMethodsInspection.getID must not return null");
        }
        return "JUnitTestCaseWithNoTests";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.case.with.no.test.methods.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseWithNoTestMethodsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("test.case.with.no.test.methods.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TestCaseWithNoTestMethodsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore test cases which have super classes with test methods", (InspectionProfileEntry)this, "ignoreSupers");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestCaseWithNoTestMethodsVisitor();
    }

    private class TestCaseWithNoTestMethodsVisitor
    extends BaseInspectionVisitor {
        private TestCaseWithNoTestMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClass superClass;
            PsiMethod[] methods;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/TestCaseWithNoTestMethodsInspection$TestCaseWithNoTestMethodsVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType() || aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!ClassUtils.isSubclass(aClass, "junit.framework.TestCase")) {
                return;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!TestUtils.isJUnitTestMethod(method)) continue;
                return;
            }
            if (TestCaseWithNoTestMethodsInspection.this.ignoreSupers && (superClass = aClass.getSuperClass()) != null) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = superClass.getMethods()) {
                    if (!TestUtils.isJUnitTestMethod(superMethod)) continue;
                    return;
                }
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

