/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceConstantFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import org.jetbrains.annotations.NotNull;

public class MagicCharacterInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("magic.character.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/internationalization/MagicCharacterInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("magic.character.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/internationalization/MagicCharacterInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceConstantFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CharacterLiteralsShouldBeExplicitlyDeclaredVisitor();
    }

    private static class CharacterLiteralsShouldBeExplicitlyDeclaredVisitor
    extends BaseInspectionVisitor {
        private CharacterLiteralsShouldBeExplicitlyDeclaredVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/internationalization/MagicCharacterInspection$CharacterLiteralsShouldBeExplicitlyDeclaredVisitor.visitLiteralExpression must not be null");
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.CHAR)) {
                return;
            }
            String text = expression.getText();
            if (text == null) {
                return;
            }
            if (text.equals(" ")) {
                return;
            }
            if (CharacterLiteralsShouldBeExplicitlyDeclaredVisitor.isDeclaredConstant(expression)) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotatedUse((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean isDeclaredConstant(PsiLiteralExpression expression) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
            if (field == null) {
                return false;
            }
            return field.hasModifierProperty("static") && field.hasModifierProperty("final");
        }
    }
}

