/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SingleClassImportInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("single.class.import.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/SingleClassImportInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("single.class.import.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/SingleClassImportInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageImportVisitor();
    }

    private static class PackageImportVisitor
    extends BaseInspectionVisitor {
        private PackageImportVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiImportStatement[] importStatements;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/imports/SingleClassImportInspection$PackageImportVisitor.visitClass must not be null");
            }
            if (!(aClass.getParent() instanceof PsiJavaFile)) {
                return;
            }
            if (JspPsiUtil.isInJspFile((PsiElement)aClass.getContainingFile())) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)aClass.getParent();
            if (file == null) {
                return;
            }
            if (!file.getClasses()[0].equals(aClass)) {
                return;
            }
            PsiImportList importList = file.getImportList();
            if (importList == null) {
                return;
            }
            for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
                if (importStatement.isOnDemand()) continue;
                this.registerError((PsiElement)importStatement, new Object[0]);
            }
        }
    }
}

