/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class MoveAnonymousToInnerClassFix
extends InspectionGadgetsFix {
    private final String name;

    public MoveAnonymousToInnerClassFix(String name) {
        this.name = name;
    }

    public MoveAnonymousToInnerClassFix() {
        this.name = InspectionGadgetsBundle.message("move.anonymous.to.inner.quickfix", new Object[0]);
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/MoveAnonymousToInnerClassFix.getName must not return null");
        }
        return string;
    }

    @Override
    public void doFix(@NotNull Project project, ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/fixes/MoveAnonymousToInnerClassFix.doFix must not be null");
        }
        PsiElement nameElement = descriptor.getPsiElement();
        PsiAnonymousClass aClass = (PsiAnonymousClass)nameElement.getParent();
        JavaRefactoringActionHandlerFactory factory = JavaRefactoringActionHandlerFactory.getInstance();
        RefactoringActionHandler anonymousToInner = factory.createAnonymousToInnerHandler();
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = dataManager.getDataContext();
        anonymousToInner.invoke(project, new PsiElement[]{aClass}, dataContext);
    }
}

