/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.FinalUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeFieldFinalFix
extends InspectionGadgetsFix {
    private final String fieldName;

    private MakeFieldFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @Nullable
    public static InspectionGadgetsFix buildFix(PsiField field) {
        if (!FinalUtils.canFieldBeFinal(field)) {
            return null;
        }
        String name = field.getName();
        return new MakeFieldFinalFix(name);
    }

    @NotNull
    public static InspectionGadgetsFix buildFixUnconditional(PsiField field) {
        MakeFieldFinalFix makeFieldFinalFix = new MakeFieldFinalFix(field.getName());
        if (makeFieldFinalFix == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/MakeFieldFinalFix.buildFixUnconditional must not return null");
        }
        return makeFieldFinalFix;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.field.final.quickfix", this.fieldName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/MakeFieldFinalFix.getName must not return null");
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiField field;
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            field = (PsiField)target;
        } else {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiField)) {
                return;
            }
            field = (PsiField)parent;
        }
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("final", true);
    }

    private static boolean isInitializedInOneInitializer(@NotNull PsiField field) {
        PsiClassInitializer[] initializers;
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/fixes/MakeFieldFinalFix.isInitializedInOneInitializer must not be null");
        }
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        boolean initializedInOneInitializer = false;
        for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
            PsiCodeBlock body;
            if (initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body = initializer.getBody(), (PsiVariable)field)) continue;
            if (initializedInOneInitializer) {
                return false;
            }
            initializedInOneInitializer = true;
        }
        return true;
    }

    private static boolean isInitializedInOneStaticInitializer(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/fixes/MakeFieldFinalFix.isInitializedInOneStaticInitializer must not be null");
        }
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        boolean initializedInOneStaticInitializer = false;
        for (PsiClassInitializer initializer : initializers) {
            PsiCodeBlock body;
            if (!initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body = initializer.getBody(), (PsiVariable)field)) continue;
            if (initializedInOneStaticInitializer) {
                return false;
            }
            initializedInOneStaticInitializer = true;
        }
        return initializedInOneStaticInitializer;
    }

    private static boolean isInitializedInConstructors(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/fixes/MakeFieldFinalFix.isInitializedInConstructors must not be null");
        }
        PsiClass containingClass = field.getContainingClass();
        PsiMethod[] constructors = containingClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            if (InitializationUtils.methodAssignsVariableOrFails(constructor, (PsiVariable)field)) continue;
            return false;
        }
        return true;
    }
}

