/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnOfCollectionFieldInspection
extends BaseInspection {
    public boolean ignorePrivateMethods = true;

    @NotNull
    public String getID() {
        if ("ReturnOfCollectionOrArrayField" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ReturnOfCollectionFieldInspection.getID must not return null");
        }
        return "ReturnOfCollectionOrArrayField";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.of.collection.array.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ReturnOfCollectionFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("return.of.collection.array.field.option", new Object[0]), (InspectionProfileEntry)this, "ignorePrivateMethods");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiField field = (PsiField)infos[0];
        PsiType type = field.getType();
        if (type instanceof PsiArrayType) {
            string = InspectionGadgetsBundle.message("return.of.collection.array.field.problem.descriptor.array", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ReturnOfCollectionFieldInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("return.of.collection.array.field.problem.descriptor.collection", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ReturnOfCollectionFieldInspection.buildErrorString must not return null");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[1];
        String text = referenceExpression.getText();
        if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Map")) {
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.SortedMap")) {
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSortedMap(" + text + ')');
            }
            return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableMap(" + text + ')');
        }
        if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Collection")) {
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Set")) {
                if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.SortedSet")) {
                    return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSortedSet(" + text + ')');
                }
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableSet(" + text + ')');
            }
            if (TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.List")) {
                return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableList(" + text + ')');
            }
            return new ReturnOfCollectionFieldFix("java.util.Collections.unmodifiableCollection(" + text + ')');
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnOfCollectionFieldVisitor();
    }

    private class ReturnOfCollectionFieldVisitor
    extends BaseInspectionVisitor {
        private ReturnOfCollectionFieldVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/encapsulation/ReturnOfCollectionFieldInspection$ReturnOfCollectionFieldVisitor.visitReturnStatement must not be null");
            }
            super.visitReturnStatement(statement);
            PsiExpression returnValue = statement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            if (containingMethod == null) {
                return;
            }
            if (ReturnOfCollectionFieldInspection.this.ignorePrivateMethods && containingMethod.hasModifierProperty("private")) {
                return;
            }
            PsiClass returnStatementClass = containingMethod.getContainingClass();
            if (returnStatementClass == null) {
                return;
            }
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)returnValue;
            PsiElement referent = referenceExpression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass fieldClass = field.getContainingClass();
            if (!returnStatementClass.equals(fieldClass)) {
                return;
            }
            if (!CollectionUtils.isArrayOrCollectionField(field)) {
                return;
            }
            this.registerError((PsiElement)returnValue, field, returnValue);
        }
    }

    private static class ReturnOfCollectionFieldFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        ReturnOfCollectionFieldFix(String replacementText) {
            this.replacementText = replacementText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("return.of.collection.field.quickfix", this.replacementText);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ReturnOfCollectionFieldInspection$ReturnOfCollectionFieldFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            ReturnOfCollectionFieldFix.replaceExpressionAndShorten((PsiExpression)referenceExpression, this.replacementText);
        }
    }
}

